<@com.html title="政策法规" import="layui,ueditor" />
<body class="gtmap greenStyle">
    <style>
        .layui-table-cell {padding:0 !important;}
        .layui-table-cell input{border:0}
        tr .active{
            text-align: center;
        }
    </style>
    <div class="gt-container">
        <form class="layui-form" id="lawsForm">
            <div class="gt-toolbar">
                <@com.toolbar />
            </div>
            <#--隐藏的表单内容-->
            <input type="hidden" class="input-text" id="lawId" name="lawId" value="${laws.lawId!}">
            <input type="hidden" class="input-text" id="treeLinkId" name="treeLinkId" value="${laws.treeLinkId!}">
            <div class="gt-content" style="min-height: 268px;">
                <div class="gt-head">
                    <h3 class="text-c">政策法规</h3>
                    <h5 class="text-r">&nbsp;</h5>
                </div>
                <table class="layui-table table-border">
                    <tbody>
                        <tr>
                            <td  class="active" style="width: 15%;">政策法规类型</td>
                            <td colspan="2"  class="pd0">
                                <input class="layui-input" id="treeName" name="treeName" type="text" value="${laws.treeName!}">
                            </td>
                            <td  class="active" style="width: 15%;">颁布日期</td>
                            <td colspan="2" class="pd0">
                                <#if laws.fpubDate??>
                                    <input type="text" class="layui-input" id="fpubDate" name="fpubDate" value="${(laws.fpubDate!.now)?string('yyyy-MM-dd')}">
                                <#else>
                                    <input type="text" class="layui-input" id="fpubDate" name="fpubDate" value="">
                                </#if>
                            </td>
                        </tr>
                        <tr>
                            <td  class="active" style="width: 15%;">标题</td>
                            <td colspan="5"  class="pd0">
                                <input class="layui-input" type="text" id="ftitle" name="ftitle" value="${laws.ftitle!}">
                            </td>
                        </tr>
                        <tr>
                            <td  class="active" style="width: 15%;">主题词</td>
                            <td colspan="5" class="pd0">
                                <input class="layui-input" type="text" id="fkeyword" name="fkeyword" value="${laws.fkeyword!}">
                            </td>
                        </tr>
                        <tr>
                            <td  class="active" style="width: 15%;">发布单位</td>
                            <td colspan="2" class="pd0">
                                <input class="layui-input" type="text" id="fpubDpt" name="fpubDpt" value="${laws.fpubDpt!}">
                            </td>
                            <td  class="active" style="width: 15%;">信息来源</td>
                            <td colspan="2" class="pd0">
                                <input class="layui-input" type="text" id="finfoSource" name="finfoSource" value="${laws.finfoSource!}">
                            </td>
                        </tr>
                        <tr>
                            <td  class="active" style="width: 15%;">文   号</td>
                            <td colspan="2" class="pd0">
                                <input class="layui-input" type="text" id="docSymbol" name="docSymbol" value="${laws.docSymbol!}">
                            </td>
                            <td  class="active" style="width: 15%;">效力级别</td>
                            <td colspan="2" class="pd0">
                                <input class="layui-input" type="text" id="effectLeve" name="effectLeve" value="${laws.effectLeve!}">
                            </td>
                        </tr>
                        <tr>
                            <td  class="active" style="width: 15%;">备注</td>
                            <td colspan="5" class="pd0">
                                <textarea class="layui-textarea" id='remark' name='remark' lay-verify="content">${laws.remark!}</textarea>
                            </td>
                        </tr>
                    </tbody>
                    <tbody>
                    <tr>
                        <td colspan="6" style="padding:0;">
                            <script id="lawContent" name="lawContent" type="text/plain">${laws.lawContent!}</script>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </form>
    </div>
    <script type="text/javascript">
        //实例化编辑器
        var ue = UE.getEditor('lawContent');
        ue.ready(function () {
            //自定义请求参数
            ue.execCommand('serverparam', {
                'id': '${laws.lawId!}',
            });
            ue.queryCommandValue('serverparam');

            UE.Editor.prototype._bkGetActionUrl = UE.Editor.prototype.getActionUrl;
            UE.Editor.prototype.getActionUrl = function (action) {
                if (action = ue.getOpt("imageActionName")){
                    return getRoot()+ ue.getOpt("imageActionName");
                }else if(action = ue.getOpt("fileActionName")){
                    return getRoot()+ ue.getOpt("fileActionName");
                }
                else {
                    return this._bkGetActionUrl.call(this.action);
                }
            }
        });
        layui.use(['form','laydate'], function() {
            //初始化模块
            var form = layui.form;
            var $ = layui.$;
            var layer = layui.layer;
            var laydate = layui.laydate;

            laydate.render({
                elem: '#fpubDate' //指定元素
            });

            //监听提交
            form.on('submit(formSave)', function(data) {
                submit();
                return false;
            });

            //表单提交
            function submit() {
                $.ajax({
                    type: "post",
                    url: "${base}/laws/save",
                    dataType: "json",
                    data: $("#lawsForm").serializeArray(),
                    beforeSend: function () {
                        layer.msg('正在保存...', {
                            icon: 16,
                            shade: 0.3,
                        })
                    },
                    complete: function () {
                    },
                    success: function (data) {
                        if (data.flag) {
                            layer.alert(data.message, {icon: 6});
                            $("#lawId").val(data.empty.lawId);
                            opener.loadInfo();
                        } else {
                            layer.msg("操作失败",{icon:2,time:2000});
                        }
                    }
                });
            }
        });
    </script>
</body>
