<@com.html title="收文办文单" import="layui,main,sign"/>
<body class="gtmap greenStyle">
<style>
    .layui-table-cell {padding:0 !important;}
    .layui-table-cell input{border:0}
    .border-t{border-top-color: red!important;}
    .border-b{border-bottom-color: red!important;}
    .border-l{border-left-color: red!important;}
    .border-r{border-right-color: red!important;}
</style>
<div class="gt-container">
    <form class="layui-form" id="receiveForm">
    <@toolbar show="save,print" />
    <#-- 存储隐藏值-->
        <input type="hidden" name="receiveId" value="${receive.receiveId!}" id="receiveId" >
        <div class="gt-content">
            <div class="layui-tab layui-tab-brief">
                <h3 class="text-c" style="color: red">收文办文单</h3>
                <h5 class="text-r">&nbsp;</h5>
                <table class="layui-table table-border">
                    <tr>
                        <td class="text-c active" style="width: 10%;">收文编号</td>
                        <td class="pd0" colspan="2" style="border-right: none">
                            <select name="receiveName" lay-filter="receivebh" lay lay-verify="required">
                                <option value="连自然资收字"<#if receive.receiveName?? && receive.receiveName=='连自然资收字'>selected </#if>>连自然资收字</option>
                                <option value="连测试收字"<#if receive.receiveName?? && receive.receiveName=='连测试收字'>selected </#if>>连测试收字</option>
                            </select>
                        </td>
                        <td style="border-right: none;border-left: none;width: 10%;" class="pd0">
                            〔<input style="width:58%!important;padding-left: 0;text-align: center" class="layui-input"  type="text" id="receiveYear" name="receiveYear" value="${receive.receiveYear!}">〕
                        </td>
                        <td style="border-left: none" class="pd0" width="100">
                            <input style="width:20%!important;padding-left: 0;text-align: center" class="layui-input" type="text" id="receiveNo" name="receiveNo" value="${receive.receiveNo!}">&nbsp;号
                        </td>
                        <#--<td style="border-left: none" class="pd0">-->
                        <#--</td>-->
                        <td class="text-c active" style="width: 10%;">来文类别</td>
                        <td class="pd0" colspan="2">
                            <select name="receiveType" lay-verify="required">
                                <option value="普通来文"<#if receive.receiveType?? && receive.receiveType=='普通来文'>selected </#if>>普通来文</option>
                                <option value="国土资源厅来文"<#if receive.receiveType?? && receive.receiveType=='国土资源厅来文'>selected </#if>>国土资源厅来文</option>
                                <option value="中央、省级来文"<#if receive.receiveType?? && receive.receiveType=='中央、省级来文'>selected </#if>>中央、省级来文</option>
                                <option value="市人民政府来文"<#if receive.receiveType?? && receive.receiveType=='市人民政府来文'>selected </#if>>市人民政府来文</option>
                                <option value="市各委、办、局来文"<#if receive.receiveType?? && receive.receiveType=='市各委、办、局来文'>selected </#if>>市各委、办、局来文</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td class="text-c active">来文文号</td>
                        <td colspan="4" class="pd0">
                            <input class="layui-input" type="text" id="originNo" name="originNo" value="${receive.originNo!}">
                        </td>
                        <td class="text-c active" >公开范围</td>
                        <td class="pd0" colspan="3">
                            <select name="publishType" lay-verify="required">
                                <option value="内网公开"<#if receive.publishType?? && receive.publishType=='内网公开'>selected </#if>>内网公开</option>
                                <option value="不公开"<#if receive.publishType?? && receive.publishType=='不公开'>selected </#if>>不公开</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td class="text-c active" >标  题</td>
                        <td colspan="8" class="pd0">
                            <input class="layui-input" type="text" id="receiveTitle" name="receiveTitle" value="${receive.receiveTitle!}">
                        </td>
                    </tr>
                    <tr>
                        <td class="text-c active">来文单位</td>
                        <td colspan="4" class="pd0">
                            <input class="layui-input" type="text" id="fromUnit" name="fromUnit" value="${receive.fromUnit!}">
                        </td>
                        <td class="text-c active" >紧急程度</td>
                        <td class="pd0" colspan="3">
                            <select name="receiveGrade" lay-verify="required">
                                <option value="平件"<#if receive.receiveGrade?? && receive.receiveGrade=='平件'>selected </#if>>平件</option>
                                <option value="急件"<#if receive.receiveGrade?? && receive.receiveGrade=='急件'>selected </#if>>急件</option>
                                <option value="紧急"<#if receive.receiveGrade?? && receive.receiveGrade=='紧急'>selected </#if>>紧急</option>
                                <option value="特急"<#if receive.receiveGrade?? && receive.receiveGrade=='特急'>selected </#if>>特急</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td class="text-c active">接收日期</td>
                        <td colspan="4" class="pd0">
                            <input class="layui-input layui-date"  type="text" id="receiveDate" name="receiveDate" placeholder="接收日期" value="${(receive.receiveDate!.now)?string('yyyy-MM-dd')}">
                        </td>
                        <td class="text-c active" >密  级</td>
                        <td class="pd0" colspan="3">
                            <select name="emergency" lay-verify="required">
                                <option value="普通"<#if receive.emergency?? && receive.emergency=='普通'>selected </#if>>普通</option>
                                <option value="内部"<#if receive.emergency?? && receive.emergency=='内部'>selected </#if>>内部</option>
                                <option value="秘密"<#if receive.emergency?? && receive.emergency=='秘密'>selected </#if>>秘密</option>
                                <option value="机密"<#if receive.emergency?? && receive.emergency=='机密'>selected </#if>>机密</option>
                                <option value="绝密"<#if receive.emergency?? && receive.emergency=='绝密'>selected </#if>>绝密</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td class="text-c active" style="height: 68px">备  注</td>
                        <td colspan="8" class="pd0">
                            <textarea class="layui-textarea" id='remark' name='remark' lay-verify="content" >${receive.remark!}</textarea>
                        </td>
                    </tr>
                    <tr>
                        <td class="text-c active" style="height: 68px!important;">承办意见</td>
                        <td colspan="8" class="gtmapSign" signKey="cbyj" noOpinion="false" multiSign="false" style="padding: 0px!important;" disabled="disabled"></td>
                    </tr>
                    <tr>
                        <td class="text-c active" style="height: 68px!important;">办公室意见</td>
                        <td colspan="8" class="gtmapSign" signKey="bgsyj" noOpinion="false" multiSign="false" style="padding: 0px!important;" disabled="disabled"></td>
                    </tr>
                    <tr>
                        <td class="text-c active" style="height: 68px!important;">办公室主任</br>审批</td>
                        <td colspan="8" class="gtmapSign" signKey="bgszr" noOpinion="false" multiSign="false" style="padding: 0px!important;" disabled="disabled"></td>
                    </tr>
                    <tr>
                        <td class="text-c active" style="height: 68px!important;">分管领导</br>审批</td>
                        <td colspan="8" class="gtmapSign" signKey="fgld" noOpinion="false" multiSign="false" style="padding: 0px!important;" disabled="disabled"></td>
                    </tr>
                </table>
            </div>
        </div>
    </form>
</div>
<script type="text/javascript">
    layui.use(['form','laydate'], function(){
        //初始化模块
        var form = layui.form;
        var $ = layui.$;
        var layer = layui.layer;
        var laydate = layui.laydate;
        //各种基于事件的操作，下面会有进一步介绍

        //收文编号
        var reno = $("[name='receiveNo']").val();
        var reyear = $("[name='receiveYear']").val();
        var rename = $("select[name='receiveName']").val();
        if(reno==null||reno==""){
            $.get("receiveNo",{name:rename,year:reyear},function(result){
                $("[name='receiveNo']").val(result);
            });
        }
        //表单红色边框
        $('.table-border tr:first-of-type td').addClass('border-t');
        $('.table-border tr:last-of-type td').addClass('border-b');
        $('.table-border tr>td:first-of-type').addClass('border-l');
        $('.table-border tr>td:last-of-type').addClass('border-r');
        //监听下拉
        form.on('select(receivebh)', function(data) {
            var name = $("select[name='receiveName']").val();
            var year = $("[name='receiveYear']").val();
            if(rename!=name) {
                $.get("receiveNo", {name: name, year: year}, function (result) {
                    $("[name='receiveNo']").val(result);
                });
                form.render('select');
            }else {
                $("[name='receiveNo']").val(reno);
            }
        });

        laydate.render({
            elem: '#receiveDate', //指定元素
            //range: true
        });

        //监听提交
        form.on('submit(formSave)', function(data) {
            submit();
            return false;
        });


        /**
         * 表单提交
         */
        function submit() {
            $.ajax({
                type: "post",
                url: "${base}/receive/save",
                dataType: "json",
                data: $("#receiveForm").serializeArray(),
                beforeSend: function () {
                    layer.msg('正在保存...', {
                        icon: 16,
                        shade: 0.01,
                        time: 2
                    })
                },
                complete: function () {
                    // layer.close(index);
                },
                success: function (data) {
                    if (data.flag) {
                        layer.msg(data.message, {icon: 1, time: 1000},function () {
                            $("#receiveId").val(data.empty.receiveId);
                            //刷新列表
//                            opener.loadInfo();
                        });
                    } else {
                        layer.msg("操作失败",{icon:2,time:2000});
                    }

                }
            });

        }

    });

</script>
</body>