<#macro html title="" import="layui">
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="X-UA-Compatible" content="IE=9; IE=8; IE=EDGE">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Content-Type" content="text/html;charset=UTF-8"/>
    <title>${title}</title>
    <script type="text/javascript">
    </script>
    <#if import??>
        <#list import?split(",") as lib>
            <#switch lib>
                <#case "layui">
                    <@style path="webjars/layui/2.4.5/css/layui.css"></@style>
                    <@style path="static/css/gtmap-public.css"></@style>
                    <#--<@style path="css/global.css"></@style>-->
                    <@style path="static/lib/font-awesome/font-awesome.css"></@style>
                    <!-- 让IE8/9支持媒体查询，从而兼容栅格 -->
                    <!--[if lt IE 9]>
                    <script src="${base!}/static/lib/html5.min.js"></script>
                    <script src="${base!}/static/lib/respond.min.js"></script>
                    <![endif]-->
                    <@script path="webjars/layui/2.4.5/layui.js"></@script>
                    <#--<@script path="js/config.js"></@script>-->
                    <#--<@script path="js/base.js"></@script>-->
                    <#break />
                <#case "ueditor">
                    <@script path="static/js/public-data.js"></@script>
                    <@script path="static/ueditor/ueditor.config.js"></@script>
                    <@script path="static/ueditor/ueditor.all.js"></@script>
                    <@script path="static/ueditor/lang/zh-cn/zh-cn.js"></@script>
                    <#break />
                <#case "jquery1.8">
                    <@script path="static/lib/schedule/jquery/jquery-1.8.3.js"></@script>
                    <#break />
                <#case "main">
                    <@script path="static/js/main.js"></@script>
                    <#break />
                <#case "layui_page">
                    <@script path="static/js/layui_page.js"></@script>
                    <#break />
                <#case "util">
                    <@script path="static/js/util.js"></@script>
                    <#break />
                <#case "screen">
                    <@script path="static/js/screen.js"></@script>
                    <#break />
                <#case "xadmin">
                    <@script path="static/js/xadmin.js"></@script>
                    <@style path="static/css/xadmin.css"></@style>
                    <#break />
                <#case "lawsTree">
                    <@script path="static/js/lawsTree.js"></@script>
                    <@style path="static/css/lawsTypeTree.css"></@style>
                    <#break />
                <#case "jquery">
                    <@script path="static/js/jquery-1.12.4.min.js"></@script>
                    <#break />
                <#case "font">
                    <@style path="static/lib/icon-font/iconfont.css"></@style>
                    <@script path="static/lib/icon-font/iconfont.js"></@script>
                    <@style path="static/css/font.css"></@style>
                    <#break />
                <#case "nav">
                    <@script path="static/js/nav.js"></@script>
                    <#break />
                <#case "ztree">
                    <@style path="static/lib/ztree/css/metroStyle/metroStyle.css"></@style>
                    <@script path="static/lib/ztree/js/jquery.ztree.core-3.5.min.js"></@script>
                    <@script path="static/lib/ztree/js/jquery.ztree.excheck-3.5.min.js"></@script>
                    <@script path="static/lib/ztree/js/jquery.ztree.exedit-3.5.min.js"></@script>
                    <@script path="static/lib/ztree/js/jquery.ztree.exhide-3.5.min.js"></@script>
                    <#break />
                <#case "xpublic">
                    <@style path="static/css/xpublic.css"></@style>
                    <#break />
                <#case "editPage">
                    <@style path="static/css/editPage.css"></@style>
                    <#break />
                <#case "dispatch">
                    <@style path="static/css/dispatch.css"></@style>
                    <#break />
                <#case "list">
                    <@style path="static/css/new-public.css"></@style>
                    <#break />
                <#case "calendar">
                    <@script path="static/lib/calendar/jquery/jquery-1.7.1.min.js"></@script>
                    <@style path="static/lib/calendar/fullcalendar/fullcalendar.css"></@style>
                    <@style path="static/lib/calendar/fullcalendar/fullcalendar.print.css"></@style>
                    <@script path="static/lib/calendar/fullcalendar/fullcalendar.js"></@script>
                    <@style path="static/lib/calendar/jqueryui/jquery-ui.css"></@style>
                    <@script path="static/lib/calendar/jqueryui/jquery-ui.js"></@script>
                    <@style path="static/lib/calendar/ext/resources/css/ext-all.css"></@style>
                    <@script path="static/lib/calendar/ext/ext-base.js"></@script>
                    <@script path="static/lib/calendar/ext/ext-all.js"></@script>
                    <#break />
                <#case "meetCalendar">
                    <@script path="static/js/meetCalendar.js"></@script>
                    <#break />
                <#case "schedule">
                    <@style path="static/lib/schedule/jquery/chosen.css"></@style>
                    <@style path="static/lib/schedule/jquery/jquery-ui.min.css"></@style>
                    <@style path="static/lib/schedule/jquery/jquery-ui.custom.css"></@style>
                    <@script path="static/lib/schedule/jquery/jquery-1.8.3.js"></@script>
                    <@script path="static/lib/schedule/jquery/jquery.min.js"></@script>
                    <@script path="static/lib/schedule/jquery/jquery-ui.js"></@script>
                    <@style path="static/lib/schedule/h-ui/css/H-ui.min.css"></@style>
                    <@style path="static/lib/schedule/h-ui/css/style.css"></@style>
                    <@style path="static/lib/schedule/h-ui/css/H-ui.doc.css"></@style>
                    <@style path="static/lib/schedule/h-ui/css/H-ui.admin.css"></@style>
                    <@script path="static/lib/schedule/jquery/jquery.history.js"></@script>
                    <@style path="static/lib/schedule/fullcalendar/fullcalendar.css"></@style>
                    <@style path="static/lib/schedule/fullcalendar/fullcalendar.print.css"></@style>
                    <@script path="static/lib/schedule/fullcalendar/fullcalendar.js"></@script>
                    <#break />
                <#case "wordOcx">
                    <#-- 第一个直接加载jquery -->
                    <@style path="static/lib/wordOcx/jquery/chosen.css"></@style>
                    <@style path="static/lib/wordOcx/jquery/jquery-ui.min.css"></@style>
                    <@style path="static/lib/wordOcx/jquery/jquery-ui.custom.css"></@style>
                    <@script path="static/lib/wordOcx/jquery-1.8.3.js"></@script>
                    <@script path="static/lib/wordOcx/jquery/jquery.min.js"></@script>
                    <@script path="static/lib/wordOcx/jquery/jquery.form.js"></@script>
                    <@script path="static/lib/wordOcx/jquery/jquery.cookie.js"></@script>
                    <!--  调用jQueryUI实现拖动 -->
                    <@script path="static/lib/wordOcx/jquery/jquery-ui.js"></@script>
                    <@script path="static/lib/wordOcx/jquery/chosen.jquery.min.js"></@script>
                    <@script path="static/lib/wordOcx/jquery/jquery.validate.min.js"></@script>
                    <@script path="static/lib/wordOcx/jquery/jquery.blockUI.js"></@script>
                    <@script path="static/lib/wordOcx/jquery/jquery.placeholder.js"></@script>
                    <@script path="static/lib/wordOcx/Ajax.js"></@script>
                <#case "view">
                    <@style path="webjars/layui/2.4.5/css/layui.css"></@style>
                    <@style path="static/font2/iconfont.css"></@style>
                    <@style path="static/css/view/new-conmon.css"></@style>
                    <!-- 让IE8/9支持媒体查询，从而兼容栅格 -->
                    <!--[if lt IE 9]>
                    <script src="${base!}/static/lib/html5.min.js"></script>
                    <script src="${base!}/static/lib/respond.min.js"></script>
                    <![endif]-->
                    <@script path="webjars/layui/2.4.5/layui.js"></@script>
                <#break />
                <#case "viewList">
                    <@style path="webjars/layui/2.4.5/css/layui.css"></@style>
                    <@style path="static/font2/iconfont.css"></@style>
                    <@style path="static/css/view/new-conmon.css"></@style>
                    <@style path="static/css/view/news-list.css"></@style>
                    <!-- 让IE8/9支持媒体查询，从而兼容栅格 -->
                    <!--[if lt IE 9]>
                    <script src="${base!}/static/lib/html5.min.js"></script>
                    <script src="${base!}/static/lib/respond.min.js"></script>
                    <![endif]-->
                    <@script path="webjars/layui/2.4.5/layui.js"></@script>
                    <#break />
                <#case "sign">
                    <@script path="static/js/sign.js"></@script>
                    <#break />
                <#default>
            </#switch>
        </#list>
    </#if>
</head>
<#--<body class="gtmap ${ctx.getEnv('system.setting.theme')!}">-->
    <#--<#nested />-->
<#--</body>-->
</html>
</#macro>

<#macro script path>
<script src="${base!}/${path}" type="text/javascript"></script>
</#macro>

<#macro style path>
<link href="${base!}/${path}" type="text/css" rel="stylesheet"/>
</#macro>

<#--工具栏-->
<#macro toolbar show="save,print">
    <#if show??>
    <div class="layui-row gt-toolbar">
        <div class="layui-col-xs12">
            <#list show?split(",") as lib>
                <#switch lib>
                    <#case "save">
                        <button class="layui-btn layui-btn-sm" type="button" id="save" lay-submit lay-filter="formSave">
                            <i class="icon-save"></i> 保 存
                        </button>
                        <#break />
                    <#case "print">
                        <button class="layui-btn layui-btn-sm" type="button" id="print">
                            <i class="icon-print"></i> 打 印
                        </button>
                        <#break />
                    <#case "add">
                        <button class="layui-btn layui-btn-sm" type="button" id="add">
                            <i class="icon-plus-sign"></i> 新 建
                        </button>
                        <#break />
                    <#case "edit">
                        <button class="layui-btn layui-btn-sm" type="button" id="edit">
                            <i class="icon-edit"></i> 修 改
                        </button>
                        <#break />
                    <#case "del">
                        <button class="layui-btn layui-btn-sm layui-btn-danger" type="button" id="del">
                            <i class="icon-trash"></i> 删 除
                        </button>
                        <#break />
                    <#case "upload">
                        <button class="layui-btn layui-btn-sm" type="button" id="upload">
                            <i class="icon-upload"></i> 上 传
                        </button>
                        <#break />
                    <#case "archive">
                        <button class="layui-btn layui-btn-sm" type="button" id="archive">
                            <i class="icon-book"></i> 归 档
                        </button>
                        <#break />
                    <#case "word">
                        <button class="layui-btn layui-btn-sm" type="button" id="word">
                            <i class="icon-file-text"></i> 导 出
                        </button>
                        <#break />
                    <#case "excel">
                        <button class="layui-btn layui-btn-sm" type="button" id="excel">
                            <i class="icon-file-text-alt"></i> 导 出
                        </button>
                        <#break />
                    <#case "select">
                        <button class="layui-btn layui-btn-sm" type="button" id="select">
                            <i class="icon-file-alt"></i> 选 择
                        </button>
                        <#break />

                    <#default>
                </#switch>
            </#list>
        </div>
        <#nested/>
    </div>
    </#if>
</#macro>

<#--表单标题-->
<#macro head title="" unit="">
<div class="gt-head">
    <h3 class="text-c">${title}</h3>
    <h5 class="text-r">${unit}</h5>
</div>
</#macro>
<#macro menuTree menus>
    <#if menus?? && menus?size gt 0>
        <#list menus as menu>
        <tr>
            <td>
            ${menu.title}
            </td>
        </tr>
            <#if menu.menuBeans?? && menu.menuBeans?size gt 0>
                <@menuTree menus = menu.menuBeans/>
            </#if>
        </#list>
    </#if>
</#macro>

