//业务通用js
layui.use(['jquery'], function() {
	var $ = layui.$;
	/**
	 * 多签名，支持默认意见配置
	 * @author 张顾培
	 * @date 2019-09-06
	 * @version 3.1
	 */
	var gtmapSign = {
		/**
		 * 多个意见分隔符
		 */
		separator : "@![SEPARATOR]!@",
		/**
		 * 查询签名
		 */
		select: function() {
			var _this = this;
			var processInsId = _this.getQueryString("processInsId");
			//var _disable = _this.getQueryString("disable");
			setTimeout(function() {
				$(".gtmapSign").each(function() {
					var tmp = $(this);
					tmp.css("padding", "0");
					tmp.html("");
					var signKey = tmp.attr("signKey");
					var noOpinion = tmp.attr("noOpinion");
					var multiSign = tmp.attr("multiSign");
					//alert(processInsId+signKey+noOpinion);
					$.post("/oa/sign/signList",{"processInsId":processInsId,"signKey":signKey},function(data){
						if (data.length > 0) {
							var flag = false;
							for (var i = 0; i < data.length; i++) {
								tmp.append(_this.init(data[i], noOpinion, i, "del"));
							}
							if (multiSign == "true" && !flag && !(operateType == 1 || operateType == 2) && _disable != "true") {
								tmp.append(_this.init({processInsId:processInsId,signKey:signKey,signOpinion:''}, noOpinion, data.length + 1, "", ""));
							}
						} else {
							tmp.append(_this.init({processInsId:processInsId,signKey:signKey,signOpinion:''}, noOpinion, 0, ""));
						}
						//_this.initDefaultOpinion(signKey);
					});
				});
			}, 100);
		},
		/**
		 * 初始化签名
		 * @param SignDTO
		 * @param noOpinion 是否无意见
		 * @param index 下标
		 * @param disable 禁用
		 * @param btnFlag 指定签名按钮背景图片（签名sign.gif、删除signdel.gif）
		 * @returns {String}
		 */
		init: function(SignDTO, noOpinion, index, btnFlag) {
			var _this = this;
			var html = '<table class="signTable" id="signTable' + SignDTO.signKey + '" index="' + index + '" style="width:100%;border:0;border-spacing:0' + (index > 0 ? ";border-top:1px solid #ccc" : "") + '">';
			html += '<tr>';
			if (noOpinion !== "true") {
				html += '<td rowspan="3" style="padding:4px;border:0' + (noOpinion !== 'true' ? ';border-right:1px solid #ccc' : '') + '">';
				html += '<textarea class="signOpinion" id="signOpinion' + SignDTO.signKey + '" index="' + index + '" style="width:100%;height:110px;padding:0;resize:none;border:none;dispaly:block">' +  (SignDTO.signOpinion == undefined ? "" : SignDTO.signOpinion) + '</textarea>';
				html += '</td>';
			}
			html += '<td style="width:130px;height:50px;border:0;padding:0;text-align:center">';
			if (SignDTO.id) {
				html += '<input type="hidden" id="id' + SignDTO.signKey + '" index="' + index + '" value="' + SignDTO.id + '"/>';
				html += '<img class="signImg" id="signImg' + SignDTO.signKey + '" index="' + index + '" style="width:120px;height:60px" src="http://192.168.2.54:8035/storage/rest/files/download/' + SignDTO.pictureId + '"/>';
			}
			html += '</td>';
			html += '</tr>';
			html += '<tr>';
			html += '<td style="text-align:center;border:0">';
			html += '<input type="button" class="signBtn" id="signBtn' + SignDTO.signKey + '" index="' + index + '" style="width:58px;height:25px;border:1px solid #ccc;cursor:pointer;background:url(\'../static/images/sign' + btnFlag + '.gif\') no-repeat center center" '+ ' onclick="' + (btnFlag == 'del' ? 'doDel(\'' + SignDTO.id + '\')' : 'doSign(\'' + SignDTO.signKey + '\',' + index + ')') + '"/>';
			html += '</td>';
			html += '</tr>';
			html += "</table>";
			return html;
		},
		/**
		 * 签名
		 * @param signKey
		 * @param index
		 * @param isNoAlert 禁用提示
		 */
		doSign: function(signKey, index) {
			var _this = this;
			$.ajax({
				async: false,
				type: 'post',
				url: "/oa/sign/signSave",
				data: {
					"processInsId": _this.getQueryString("processInsId"),
					"signKey": signKey,
					"signOpinion": $("textarea[id='signOpinion" + signKey + "'][index='" + index + "']").val()
				},
				success: function(data) {
					console.log(data);
					if (data == "true") {
						_this.select();
						//alert("操作成功！");
					}
				},
				error: function() {
					if (data != "true") {
						alert("操作失败！");
					}
				}
			});
		},
		/**
		 * 删除签名
		 * @param id
		 */
		doDel: function(id) {
			var _this = this;
			$.ajax({
				async: false,
				type: 'post',
				url: "/oa/sign/signDel",
				data: {
					"id": id
				},
				success: function(data) {
					console.log(data);
					if (data == "true") {
						_this.select();
						//alert("操作成功！");
					}
				},
				error: function() {
					if (data != "true") {
						alert("操作失败！");
					}
				}
			});
		},
		/**
		 * 获取url参数
		 * @param key 参数名
		 * @returns
		 */
		getQueryString : function(key) {
			var reg = new RegExp("(^|&)" + key + "=([^&]*)(&|$)");
			var r = location.search.substr(1).match(reg);
			if (r != null) {
				return unescape(r[2]);
			}
			return null;
		},
	};

	window.doSign = function(signKey,index){
		gtmapSign.doSign(signKey,index);
	}

	window.doDel = function(id){
		gtmapSign.doDel(id);
	}
	// 加载签名
	gtmapSign.select();
});