/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.util;

import com.gtis.oa.model.LawsType;
import com.gtis.oa.service.LawsService;
import com.gtis.oa.service.LawsTypeService;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@Configuration
@EnableScheduling
public class SaticScheduleTask {
    @Autowired
    LawsTypeService lawsTypeService;
    @Autowired
    LawsService lawsService;

    @Scheduled(cron="0 0 0 1/7 * ?")
    public void saveTreeLawsType() {
        String url = "http://f.mnr.gov.cn/";
        try {
            Map map = this.lawsTypeService.getLawsTypeWithUrl(url);
            for (String key : map.keySet()) {
                String value = (String)map.get(key);
                String[] values = value.split(",");
                LawsType lawsTypeNew = new LawsType();
                lawsTypeNew.setTypeId(key);
                lawsTypeNew.setFmemo(values[1]);
                lawsTypeNew.setFname(values[1]);
                lawsTypeNew.setFtypeParentId(values[0]);
                lawsTypeNew.setIsUse("\u662f");
                lawsTypeNew.setSort(Integer.valueOf(Integer.parseInt(key)));
                this.lawsTypeService.saveOrUpdate((Object)lawsTypeNew);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Scheduled(cron="0 0 1 1/7 * ?")
    public void saveTreeLaws() {
        String url = "http://f.mnr.gov.cn/index_3553.html";
        int s = 0;
        for (int i = 1; i < 97; ++i) {
            int updataC = this.lawsService.getLawsWithUrl(url);
            System.out.print(url + (s += updataC));
            url = "http://f.mnr.gov.cn/index_3553_" + i + ".html";
        }
    }
}

