/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.util;

import cn.gtmap.gtc.clients.UserManagerClient;
import cn.gtmap.gtc.sso.domain.dto.OrganizationDto;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import com.gtis.oa.config.SpringConfig;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

/*
 * Exception performing whole class analysis ignored.
 */
public class CommonUtil {
    private static final Logger log = LoggerFactory.getLogger(CommonUtil.class);
    public static final Pattern NUMBER_PATTERN = Pattern.compile("[^0-9]");
    public static final Pattern NUMERIC_PATTERN = Pattern.compile("^-{0,1}[0-9]+([.]{1}[0-9]+){0,1}$");

    public static UserDto getUser() {
        String username;
        Authentication authentication;
        UserManagerClient userManagerClient = (UserManagerClient)SpringConfig.getBean(UserManagerClient.class);
        if (userManagerClient != null && (authentication = SecurityContextHolder.getContext().getAuthentication()) != null && StringUtils.isNotBlank((CharSequence)(username = authentication.getName()))) {
            return userManagerClient.getUserDetailByUsername(username);
        }
        return null;
    }

    public static String getUserId() {
        UserDto userDto = CommonUtil.getUser();
        if (userDto != null) {
            return userDto.getId();
        }
        return null;
    }

    public static String getUsername() {
        UserDto userDto = CommonUtil.getUser();
        if (userDto != null) {
            return userDto.getAlias();
        }
        return null;
    }

    public static String getUserRegionCode() {
        UserDto userDto = CommonUtil.getUser();
        if (userDto != null && CollectionUtils.isNotEmpty((Collection)userDto.getOrgRecordList())) {
            return ((OrganizationDto)userDto.getOrgRecordList().get(0)).getRegionCode();
        }
        return null;
    }

    public static String getUserRegionCode(boolean flag) {
        String regionCode = CommonUtil.getUserRegionCode();
        if (StringUtils.isNotBlank((CharSequence)regionCode)) {
            if (flag) {
                if (regionCode.length() == 6 && regionCode.endsWith("00")) {
                    regionCode = regionCode.substring(0, 4);
                }
            } else if (regionCode.length() == 4) {
                regionCode = regionCode + "00";
            }
        }
        return regionCode;
    }

    public static String dealXzqdm(String xzqdm) {
        if (StringUtils.length((CharSequence)xzqdm) == 6) {
            if (StringUtils.endsWith((CharSequence)xzqdm, (CharSequence)"0000")) {
                xzqdm = StringUtils.left((String)xzqdm, (int)2);
            } else if (StringUtils.endsWith((CharSequence)xzqdm, (CharSequence)"00")) {
                xzqdm = StringUtils.left((String)xzqdm, (int)4);
            }
        }
        return xzqdm;
    }

    public static DecimalFormat initDecimalFormat(Integer count) {
        return CommonUtil.initDecimalFormat((Integer)count, (boolean)true);
    }

    public static DecimalFormat initDecimalFormat(Integer count, boolean buling) {
        String formatStr = "#0.";
        if (count == null) {
            count = 8;
        }
        if (count <= 0) {
            formatStr = "#0";
        } else {
            for (int i = 0; i < count; ++i) {
                formatStr = buling ? formatStr + "0" : formatStr + "#";
            }
        }
        DecimalFormat myformat = new DecimalFormat(formatStr);
        return myformat;
    }

    public static Double formatTwoNumber(Double value) {
        DecimalFormat df = new DecimalFormat("##############0.00");
        Double value1 = Double.parseDouble(df.format(value));
        return value1;
    }

    public static Double formatFourNumber(Double value) {
        DecimalFormat df = new DecimalFormat("##############0.0000");
        Double value1 = Double.parseDouble(df.format(value));
        return value1;
    }

    public static String IntegerToString(Integer integer) {
        if (integer != null) {
            return String.valueOf(integer);
        }
        return "";
    }

    public static String bigDecimalToString(BigDecimal bigDecimalData, Integer count) {
        if (bigDecimalData == null) {
            return "";
        }
        DecimalFormat myformat = CommonUtil.initDecimalFormat((Integer)count);
        return myformat.format(bigDecimalData);
    }

    public static String bigDecimalToString(BigDecimal bigDecimalData, Integer count, boolean buling) {
        if (bigDecimalData == null) {
            return "";
        }
        DecimalFormat myformat = CommonUtil.initDecimalFormat((Integer)count, (boolean)buling);
        return myformat.format(bigDecimalData);
    }

    public static BigDecimal stringtoBigDecimal(String bigDecimalData, Integer count) {
        try {
            if (StringUtils.isBlank((CharSequence)bigDecimalData) || "null".equals(bigDecimalData)) {
                return new BigDecimal(0);
            }
            DecimalFormat myformat = CommonUtil.initDecimalFormat((Integer)count, (boolean)true);
            return new BigDecimal(myformat.format(new BigDecimal(bigDecimalData)));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static BigDecimal stringtoBigDecimal(String bigDecimalData, Integer count, boolean buling) {
        try {
            if (StringUtils.isBlank((CharSequence)bigDecimalData) || "null".equals(bigDecimalData)) {
                return new BigDecimal(0);
            }
            DecimalFormat myformat = CommonUtil.initDecimalFormat((Integer)count, (boolean)buling);
            return new BigDecimal(myformat.format(new BigDecimal(bigDecimalData)));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static BigDecimal bigDecimalToBigDecimal(BigDecimal bigDecimalData, Integer count) {
        if (bigDecimalData == null) {
            return new BigDecimal(0);
        }
        DecimalFormat myformat = CommonUtil.initDecimalFormat((Integer)count);
        return new BigDecimal(myformat.format(bigDecimalData));
    }

    public static BigDecimal bigDecimalToBigDecimal(BigDecimal bigDecimalData, Integer count, boolean buling) {
        if (bigDecimalData == null) {
            return new BigDecimal(0);
        }
        DecimalFormat myformat = CommonUtil.initDecimalFormat((Integer)count, (boolean)buling);
        return new BigDecimal(myformat.format(bigDecimalData));
    }

    public static Integer DoubleToInteger(Double value) {
        Integer input = 0;
        try {
            DecimalFormat myformat = new DecimalFormat("#0");
            String s = myformat.format(value);
            input = Integer.parseInt(s);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return input;
    }

    public static Integer StringToInteger(String str) {
        Integer integer = null;
        try {
            if (str != null && !"".equals(str) && !str.equalsIgnoreCase(null)) {
                integer = Integer.valueOf(str);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return integer;
    }

    public static String getIntegerStr(String str) {
        String numberRegEx = "[^0-9]";
        Pattern pattern = Pattern.compile(numberRegEx);
        Matcher matcher = pattern.matcher(str);
        String result = matcher.replaceAll("");
        return result;
    }

    public static String getNumberStr(String str) {
        String numberRegEx = "([^(\\d|\\.)])";
        Pattern pattern = Pattern.compile(numberRegEx);
        Matcher matcher = pattern.matcher(str);
        String result = matcher.replaceAll("");
        return result;
    }

    public static String paseChinaNum(int value) {
        String chinaNum = "";
        char[] valueStr = (value + "").toCharArray();
        char[] SCDigits = new char[]{'\u96f6', '\u4e00', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d'};
        if (valueStr != null) {
            if (valueStr.length == 2) {
                chinaNum = valueStr[0] == '1' ? "\u5341" + SCDigits[Integer.parseInt(valueStr[1] + "")] : SCDigits[Integer.parseInt(valueStr[0] + "")] + "\u5341" + SCDigits[Integer.parseInt(valueStr[1] + "")];
            } else if (valueStr.length == 1) {
                chinaNum = SCDigits[Integer.parseInt(valueStr[0] + "")] + "";
            }
        }
        chinaNum = StringUtils.replace((String)chinaNum, (String)"\u96f6", (String)"");
        return chinaNum;
    }

    public static int paseArabicNum(String str) {
        String str1 = new String();
        String str2 = new String();
        String str3 = new String();
        int k = 0;
        boolean dealflag = true;
        String chineseNum = StringUtils.remove((String)str, (String)"\u96f6");
        for (int i = 0; i < chineseNum.length(); ++i) {
            if (chineseNum.charAt(i) == '\u4ebf') {
                str1 = chineseNum.substring(0, i);
                k = i + 1;
                dealflag = false;
            }
            if (chineseNum.charAt(i) != '\u4e07') continue;
            str2 = chineseNum.substring(k, i);
            str3 = str.substring(i + 1);
            dealflag = false;
        }
        if (dealflag) {
            str3 = chineseNum;
        }
        int result = CommonUtil.sectionChinese((String)str1) * 100000000 + CommonUtil.sectionChinese((String)str2) * 10000 + CommonUtil.sectionChinese((String)str3);
        return result;
    }

    public static int sectionChinese(String str) {
        int value = 0;
        int sectionNum = 0;
        String[] chnNumChar = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
        char[] chnNumChinese = new char[]{'\u96f6', '\u4e00', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d'};
        HashMap<Character, Integer> intList = new HashMap<Character, Integer>();
        for (int j = 0; j < chnNumChar.length; ++j) {
            intList.put(Character.valueOf(chnNumChinese[j]), j);
        }
        intList.put(Character.valueOf('\u5341'), 10);
        intList.put(Character.valueOf('\u767e'), 100);
        intList.put(Character.valueOf('\u5343'), 1000);
        if (StringUtils.startsWith((CharSequence)str, (CharSequence)"\u5341")) {
            str = "\u4e00" + str;
        }
        for (int i = 0; i < str.length(); ++i) {
            int v = MapUtils.getIntValue(intList, (Object)Character.valueOf(str.charAt(i)));
            if (v == 10 || v == 100 || v == 1000) {
                sectionNum = v * sectionNum;
                value += sectionNum;
                continue;
            }
            if (i == str.length() - 1) {
                value += v;
                continue;
            }
            sectionNum = v;
        }
        return value;
    }

    public static String addBigDecimal(Object aa, Object bb) {
        BigDecimal rs = BigDecimal.ZERO;
        if (aa != null && !"".equals(aa.toString())) {
            rs = rs.add(new BigDecimal(aa.toString()));
        }
        if (bb != null && !"".equals(bb.toString())) {
            rs = rs.add(new BigDecimal(bb.toString()));
        }
        if (BigDecimal.ZERO.compareTo(rs) == 0) {
            return "0";
        }
        return rs.toString();
    }

    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        return NUMERIC_PATTERN.matcher(str).matches();
    }

    public static String doubleStringToString(String doubleData, Integer count) {
        double input = 0.0;
        if (StringUtils.isBlank((CharSequence)doubleData) || "null".equals(doubleData)) {
            return "";
        }
        input = Double.parseDouble(doubleData);
        DecimalFormat myformat = CommonUtil.initDecimalFormat((Integer)count);
        return myformat.format(input);
    }

    public static Double doubleToDouble(Double doubleData, Integer count) {
        if (doubleData == null) {
            return 0.0;
        }
        DecimalFormat myformat = CommonUtil.initDecimalFormat((Integer)count);
        return new Double(myformat.format(doubleData));
    }

    public static Double doubleToDouble(Double doubleData, Integer count, boolean buling) {
        if (doubleData == null) {
            return 0.0;
        }
        DecimalFormat myformat = CommonUtil.initDecimalFormat((Integer)count, (boolean)buling);
        return new Double(myformat.format(doubleData));
    }

    public static String DoubleToString(Double doubleData, Integer count) {
        if (doubleData == null) {
            return "";
        }
        DecimalFormat myformat = CommonUtil.initDecimalFormat((Integer)count);
        return myformat.format(doubleData);
    }

    public static String DoubleToString(Double doubleData, Integer count, boolean buling) {
        if (doubleData == null) {
            return "";
        }
        DecimalFormat myformat = CommonUtil.initDecimalFormat((Integer)count, (boolean)buling);
        return myformat.format(doubleData);
    }

    public static Double StringToDouble(String str, Integer count) {
        if (StringUtils.isBlank((CharSequence)str) || "null".equals(str)) {
            return null;
        }
        Double dbl = null;
        try {
            DecimalFormat myformat = CommonUtil.initDecimalFormat((Integer)count);
            dbl = myformat.parse(str).doubleValue();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return dbl;
    }

    public static Object getMapKeyByValue(Map map, String value) {
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            if (!entry.getValue().equals(value)) continue;
            Object s = entry.getKey();
            return s;
        }
        return null;
    }

    public static String getActualStr(Element root, String str) {
        String rootStr;
        int idx;
        if (root != null && StringUtils.isNotBlank((CharSequence)str) && (idx = StringUtils.indexOfIgnoreCase((CharSequence)(rootStr = root.asXML()), (CharSequence)("DATANAME=\"" + str + "\""))) != -1) {
            return StringUtils.substring((String)rootStr, (int)(idx + 10), (int)(idx + 10 + str.length()));
        }
        return "";
    }

    public static TemplateHashModel useStaticPackage(String packageName) {
        try {
            BeansWrapper wrapper = new BeansWrapper(Configuration.VERSION_2_3_26);
            TemplateHashModel staticModels = wrapper.getStaticModels();
            TemplateHashModel fileStatics = (TemplateHashModel)staticModels.get(packageName);
            return fileStatics;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String freemarkerProcess(Map input, String templateStr) {
        StringTemplateLoader stringLoader = new StringTemplateLoader();
        String template = "content";
        stringLoader.putTemplate(template, templateStr);
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_26);
        cfg.setTemplateLoader((TemplateLoader)stringLoader);
        try {
            Template templateCon = cfg.getTemplate(template);
            StringWriter writer = new StringWriter();
            templateCon.process((Object)input, (Writer)writer);
            return writer.toString();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (TemplateException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static String chineseNumber2IntStr(String chineseNumber, int attachNum) {
        int i;
        int i2;
        if (StringUtils.isBlank((CharSequence)chineseNumber)) {
            return "";
        }
        boolean isOk = false;
        boolean isNum = false;
        int begin = 0;
        if (StringUtils.contains((CharSequence)chineseNumber, (CharSequence)"\u6751")) {
            begin = StringUtils.indexOf((CharSequence)chineseNumber, (CharSequence)"\u6751");
        }
        String tmp = "\u4e00,\u4e8c,\u4e09,\u56db,\u4e94,\u516d,\u4e03,\u516b,\u4e5d,\u5341";
        int j = chineseNumber.length();
        for (int i3 = begin; i3 < j; ++i3) {
            char c = chineseNumber.charAt(i3);
            if (c >= '0' && c <= '9') {
                isOk = true;
                isNum = true;
                begin = i3;
                break;
            }
            if (!StringUtils.contains((CharSequence)tmp, (int)c)) continue;
            isOk = true;
            begin = i3;
            break;
        }
        if (!isOk) {
            return chineseNumber;
        }
        tmp = "\u4e00,\u4e8c,\u4e09,\u56db,\u4e94,\u516d,\u4e03,\u516b,\u4e5d,\u5341,\u767e,\u5343,\u4e07,\u4ebf";
        String tmpStr = "";
        int j2 = chineseNumber.length();
        for (i2 = begin; i2 < j2; ++i2) {
            char c = chineseNumber.charAt(i2);
            if (isNum) {
                if (c < '0' || c > '9') break;
                tmpStr = tmpStr + c;
                continue;
            }
            if (!StringUtils.contains((CharSequence)tmp, (int)c)) break;
            tmpStr = tmpStr + c;
        }
        chineseNumber = tmpStr;
        if (isNum) {
            if (attachNum > chineseNumber.length()) {
                j2 = attachNum - chineseNumber.length();
                for (i2 = 0; i2 < j2; ++i2) {
                    chineseNumber = "0" + chineseNumber;
                }
            }
            return chineseNumber;
        }
        int result = 0;
        int temp = 1;
        int count = 0;
        char[] cnArr = new char[]{'\u4e00', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d'};
        char[] chArr = new char[]{'\u5341', '\u767e', '\u5343', '\u4e07', '\u4ebf'};
        for (i = 0; i < chineseNumber.length(); ++i) {
            int j3;
            boolean b = true;
            char c = chineseNumber.charAt(i);
            for (j3 = 0; j3 < cnArr.length; ++j3) {
                if (c != cnArr[j3]) continue;
                if (0 != count) {
                    result += temp;
                    temp = 1;
                    count = 0;
                }
                temp = j3 + 1;
                b = false;
                break;
            }
            if (b) {
                for (j3 = 0; j3 < chArr.length; ++j3) {
                    if (c != chArr[j3]) continue;
                    switch (j3) {
                        case 0: {
                            temp *= 10;
                            break;
                        }
                        case 1: {
                            temp *= 100;
                            break;
                        }
                        case 2: {
                            temp *= 1000;
                            break;
                        }
                        case 3: {
                            temp *= 10000;
                            break;
                        }
                        case 4: {
                            temp *= 100000000;
                            break;
                        }
                    }
                    ++count;
                }
            }
            if (i != chineseNumber.length() - 1) continue;
            result += temp;
        }
        chineseNumber = result + "";
        if (attachNum > chineseNumber.length()) {
            int j4 = attachNum - chineseNumber.length();
            for (i = 0; i < j4; ++i) {
                chineseNumber = "0" + chineseNumber;
            }
        }
        return chineseNumber;
    }

    public static String getProjectPath() {
        String path = new CommonUtil().getClass().getResource("/").getPath();
        path = StringUtils.substring((String)path, (int)1, (int)StringUtils.indexOf((CharSequence)path, (CharSequence)"WEB-INF"));
        return path;
    }
}

