/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.mapper.LawsMapper;
import com.gtis.oa.model.Laws;
import com.gtis.oa.model.page.LawsPage;
import com.gtis.oa.service.LawsService;
import com.gtis.oa.util.CalendarUtil;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LawsServiceImpl
extends ServiceImpl<LawsMapper, Laws>
implements LawsService {
    @Autowired
    LawsMapper lawsMapper;
    private int countUA = 1;

    public IPage<Laws> findByPage(LawsPage lawsPage) {
        return this.lawsMapper.findByPage(lawsPage);
    }

    public int getLawsWithUrl(String url) {
        int updateCount = 0;
        try {
            Document document = this.jsoupIsConnect(url);
            if (document == null) {
                return updateCount;
            }
            Elements conTable = document.getElementsByClass("con-table");
            Elements docst = conTable.select("li");
            for (Element elementT : docst) {
                Map map;
                Elements line = elementT.select("table");
                Elements nodes = line.select("tr > td");
                String contentUrl = ((Element)nodes.get(1)).select("a").attr("href");
                LawsPage lawsPage = new LawsPage();
                lawsPage.setEffectLeve(((Element)nodes.get(13)).text());
                lawsPage.setFpubDpt(((Element)nodes.get(7)).text());
                lawsPage.setFtitle(((Element)nodes.get(1)).text());
                lawsPage.setTreeName(((Element)nodes.get(11)).text());
                lawsPage.setUserArea(((Element)nodes.get(9)).text());
                IPage lawsIPage = this.findByPage(lawsPage);
                if (lawsIPage.getRecords().size() > 0 || (map = this.getLawsContent(contentUrl)) == null || map.isEmpty()) continue;
                Laws laws = new Laws();
                laws.setTreeName(((Element)nodes.get(11)).text());
                laws.setCreateDate(new Date());
                laws.setDocSymbol(((Element)nodes.get(3)).text().replace("\u00a0", "").trim());
                laws.setEffectLeve(((Element)nodes.get(13)).text());
                laws.setFpubDate(CalendarUtil.formatChinaDate((String)((Element)nodes.get(5)).text()));
                laws.setFpubDpt(((Element)nodes.get(7)).text());
                laws.setIsfinish(((Element)nodes.get(17)).text());
                laws.setFtitle(((Element)nodes.get(1)).text());
                laws.setLawContent((String)map.get("lawContent"));
                laws.setUserArea(((Element)nodes.get(9)).text());
                laws.setFkeyword(((Element)nodes.get(1)).text());
                laws.setFinfoSource((String)map.get("infoSource"));
                laws.setLawId(UUID.hex32());
                this.saveOrUpdate((Object)laws);
                ++updateCount;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return updateCount;
    }

    public Map<String, String> getLawsContent(String url) {
        HashMap<String, String> map = new HashMap<String, String>();
        String contentUrl = "http://f.mnr.gov.cn" + url;
        try {
            Document document = this.jsoupIsConnect(contentUrl);
            if (document == null) {
                return null;
            }
            Element content = document.getElementById("content");
            String lawContent = content.toString();
            Elements mid = document.getElementsByClass("mid-4");
            Elements spans = mid.select("span");
            String infoSource = ((Element)spans.get(2)).text();
            map.put("lawContent", lawContent);
            map.put("infoSource", infoSource);
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return map;
        }
    }

    public Document jsoupIsConnect(String urls) {
        int counts = 0;
        String[] ua = new String[]{"Mozilla/5.0 (Windows NT 6.1; WOW64; rv:46.0) Gecko/20100101 Firefox/46.0", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.87 Safari/537.36 OPR/37.0.2178.32", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/534.57.2 (KHTML, like Gecko) Version/5.1.7 Safari/534.57.2", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.101 Safari/537.36", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/46.0.2486.0 Safari/537.36 Edge/13.10586", "Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko", "Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.1; WOW64; Trident/6.0)", "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0)", "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1; WOW64; Trident/4.0)", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.106 BIDUBrowser/8.3 Safari/537.36", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.80 Safari/537.36 Core/1.47.277.400 QQBrowser/9.4.7658.400", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/48.0.2564.116 UBrowser/5.6.12150.8 Safari/537.36", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/38.0.2125.122 Safari/537.36 SE 2.X MetaSr 1.0", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/48.0.2564.116 Safari/537.36 TheWorld 7", "Mozilla/5.0 (Windows NT 6.1; W\u2026) Gecko/20100101 Firefox/60.0"};
        if (urls == null || urls.length() <= 0) {
            return null;
        }
        while (counts < 5) {
            try {
                Thread.currentThread();
                Thread.sleep(8000L);
                Document doc = Jsoup.connect((String)urls).timeout(5000).userAgent(ua[this.countUA % ua.length]).get();
                ++this.countUA;
                return doc;
            }
            catch (IOException e) {
                ++this.countUA;
                System.out.print(urls + " \u3010\u8bbf\u95ee\u6b21\u6570:" + ++counts + "\u3011 ");
            }
            catch (Exception exception) {
            }
        }
        return null;
    }
}

