/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.model.dict;

import com.alibaba.fastjson.JSON;
import com.gtis.oa.model.dict.Dict;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="oa_dict_item")
public class DictItem {
    @Id
    @Column(length=32)
    private String id;
    @Column(length=128, nullable=false)
    private String name;
    @Column(length=128)
    private String title;
    @Column(nullable=true)
    private String value;
    @Column(columnDefinition="number(3,0)")
    private int orderNumber = 0;
    @ManyToOne
    @JoinColumn(name="dict_id")
    private Dict dict;

    public DictItem() {
    }

    public DictItem(String name, String title) {
        this.name = name;
        this.title = title;
    }

    public DictItem(String name, String title, String value) {
        this.name = name;
        this.title = title;
        this.value = value;
    }

    public DictItem(String name, String title, String value, Dict dict) {
        this.name = name;
        this.title = title;
        this.value = value;
        this.dict = dict;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(int orderNumber) {
        this.orderNumber = orderNumber;
    }

    public Dict getDict() {
        return this.dict;
    }

    public void setDict(Dict dict) {
        this.dict = dict;
    }

    public Map getJsonValue() {
        return (Map)JSON.parseObject((String)this.value, Map.class);
    }
}

