/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.model.dict;

import com.gtis.oa.model.dict.DictItem;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;

@Entity
@Table(name="oa_dict")
public class Dict {
    @Id
    @Column(length=32)
    private String id;
    @Column(length=128, nullable=false, unique=true)
    private String name;
    @Column(length=128)
    private String title;
    @Column(name="order_number", columnDefinition="number(3,0)")
    private int order = 0;
    @Column(length=256)
    private String sql;
    @OneToMany(mappedBy="dict", cascade={CascadeType.ALL})
    @OrderBy(value="order")
    private Set<DictItem> items = new HashSet();
    private boolean deletable = true;

    public Dict() {
    }

    public Dict(String name, String title) {
        this.name = name;
        this.title = title;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public Set<DictItem> getItems() {
        return this.items;
    }

    public boolean isDeletable() {
        return this.deletable;
    }

    public void setDeletable(boolean deletable) {
        this.deletable = deletable;
    }

    public Dict addDictItem(DictItem item) {
        item.setDict(this);
        this.items.add(item);
        return this;
    }

    public void deleteItem(DictItem item) {
        this.items.remove(item);
    }

    public int itemSize() {
        return this.items.size();
    }

    public DictItem getDictItem(String name) {
        for (DictItem item : this.items) {
            if (!item.getName().equals(name)) continue;
            return item;
        }
        throw new RuntimeException(" dict [ " + name + " ] not found");
    }
}

