/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.controller;

import cn.gtmap.common.utils.FileUtil;
import cn.gtmap.common.utils.RequestUtils;
import cn.gtmap.gtc.storage.clients.v1.StorageClient;
import cn.gtmap.gtc.storage.domain.dto.MultipartDto;
import cn.gtmap.gtc.storage.domain.dto.StorageDto;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.gtis.oa.util.CommonUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/upload"})
public class UploadController {
    private static final Logger log = LoggerFactory.getLogger(UploadController.class);
    @Autowired
    StorageClient storageClient;
    private static String rootPath = CommonUtil.getProjectPath();

    @ResponseBody
    @RequestMapping(value={"/images"})
    public Map<String, Object> images(@RequestParam(value="file", required=false) MultipartFile multipartFile, HttpServletRequest request) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)6);
        if (multipartFile == null) {
            System.out.println("\u672a\u83b7\u5f97\u4e0a\u4f20\u6587\u4ef6!");
            return null;
        }
        String proid = RequestUtils.getParameter((HttpServletRequest)request, (String)"id");
        try {
            MultipartDto multipartDto = new MultipartDto();
            multipartDto.setData(multipartFile.getBytes());
            multipartDto.setSpaceCode(proid);
            multipartDto.setClientId("officeAut");
            multipartDto.setName(multipartFile.getName());
            multipartDto.setSize(multipartFile.getSize());
            multipartDto.setContentType(multipartFile.getContentType());
            multipartDto.setOriginalFilename(multipartFile.getOriginalFilename());
            StorageDto storageDto = this.storageClient.multipartUpload(multipartDto);
            String fileName = multipartFile.getOriginalFilename();
            File file = FileUtil.getFileByMvc((MultipartFile)multipartFile, (HttpServletRequest)request, (String)"");
            String tempPath = "/static/temp/" + fileName;
            String relativeUrl = rootPath + tempPath;
            FileUtil.copyFile((String)file.toString(), (String)relativeUrl);
            params.put("state", "SUCCESS");
            params.put("url", tempPath);
            params.put("size", multipartFile.getSize());
            params.put("original", fileName);
            params.put("type", multipartFile.getContentType());
            params.put("filename", multipartFile.getOriginalFilename());
            System.out.println(JSON.toJSON((Object)params));
        }
        catch (Exception e) {
            params.put("state", "ERROR");
            log.error(e.getMessage());
        }
        return params;
    }
}

