/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.Telephone;
import com.gtis.oa.model.page.TelephonePage;
import com.gtis.oa.service.TelephoneService;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/telephone"})
public class TelephoneController {
    @Autowired
    TelephoneService telephoneService;

    @RequestMapping(value={"/index"})
    public String index(Model model, String processInsId) {
        Telephone telephone = null;
        if (StringUtils.isNotBlank((String)processInsId)) {
            telephone = (Telephone)this.telephoneService.getById((Serializable)((Object)processInsId));
        }
        if (telephone == null) {
            telephone = new Telephone();
            telephone.setId(processInsId);
        }
        model.addAttribute("telephone", (Object)telephone);
        return "officeapply/telephone/telephone_edit";
    }

    @RequestMapping(value={"/list"})
    public String list(Model model, String type) {
        model.addAttribute("type", (Object)type);
        return "officeapply/telephone/telephone_list";
    }

    @RequestMapping(value={"/findByPage"})
    @ResponseBody
    public IPage<Telephone> findByPage(TelephonePage telephonePage) {
        IPage tel = null;
        try {
            tel = this.telephoneService.findByPage(telephonePage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tel;
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public ResponseMessage<Telephone> save(Telephone telephone) {
        return new ResponseMessage(Boolean.valueOf(this.telephoneService.saveOrUpdate((Object)telephone)), (Object)telephone);
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public ResponseMessage<Telephone> delete(String[] ids) {
        return new ResponseMessage(Boolean.valueOf(this.telephoneService.removeByIds(Arrays.asList(ids))));
    }
}

