/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.controller;

import cn.gtmap.gtc.sso.domain.dto.OrganizationDto;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.model.Reimbursement;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.ReimbursementPage;
import com.gtis.oa.service.ReimbursementService;
import com.gtis.oa.util.CommonUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reimbursement"})
public class ReimbursementController {
    @Autowired
    private ReimbursementService reimbursementService;

    @RequestMapping(value={"/index"})
    public String index(Model model, String processInsId) {
        Reimbursement reimbursement = null;
        if (StringUtils.isNotBlank((String)processInsId)) {
            reimbursement = (Reimbursement)this.reimbursementService.getById((Serializable)((Object)processInsId));
        }
        if (reimbursement == null) {
            reimbursement = new Reimbursement();
            reimbursement.setReimId(processInsId);
            reimbursement.setApplyTime(new Date());
            reimbursement.setApplyPeople(CommonUtil.getUser().getUsername());
            reimbursement.setApplyUnit(((OrganizationDto)CommonUtil.getUser().getOrgRecordList().get(0)).getName());
            this.reimbursementService.save((Object)reimbursement);
        }
        model.addAttribute("reimbursement", (Object)reimbursement);
        return "officeapply/reimbursement/reimbursement_edit";
    }

    @RequestMapping(value={"/list"})
    public String list(Model model, String type) {
        model.addAttribute("type", (Object)type);
        return "officeapply/reimbursement/reimbursement_list";
    }

    @RequestMapping(value={"/findByPage"})
    @ResponseBody
    public IPage<Reimbursement> findByPage(ReimbursementPage reimbursementPage) {
        return this.reimbursementService.findByPage(reimbursementPage);
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public ResponseMessage<Reimbursement> save(Reimbursement reimbursement) {
        return new ResponseMessage(Boolean.valueOf(this.reimbursementService.saveOrUpdate((Object)reimbursement)), (Object)reimbursement);
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public ResponseMessage<Reimbursement> delete(String[] ids) {
        return new ResponseMessage(Boolean.valueOf(this.reimbursementService.removeByIds(Arrays.asList(ids))));
    }
}

