/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.model.Receive;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.ReceivePage;
import com.gtis.oa.service.ReceiveService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/receive"})
public class ReceiveController {
    @Autowired
    ReceiveService receiveService;

    @RequestMapping(value={"/index"})
    public String index(Model model, String processInsId) {
        Receive receive = null;
        if (StringUtils.isNotBlank((String)processInsId)) {
            receive = (Receive)this.receiveService.getById((Serializable)((Object)processInsId));
        }
        if (receive == null) {
            receive = new Receive();
            receive.setReceiveId(processInsId);
            Calendar calendar = Calendar.getInstance();
            int year = calendar.get(1);
            receive.setReceiveYear(year + "");
            receive.setReceiveDate(new Date());
            receive.setReplyDate(new Date());
            this.receiveService.save((Object)receive);
        }
        model.addAttribute("receive", (Object)receive);
        return "document/receive/receive_edit";
    }

    @RequestMapping(value={"/list"})
    public String list() {
        return "document/receive/receive_list";
    }

    @RequestMapping(value={"/viewList"})
    public String viewList() {
        return "document/receive/receive_list_view";
    }

    @RequestMapping(value={"/findByPage"})
    @ResponseBody
    public IPage<Receive> findByPage(ReceivePage receivePage) {
        return this.receiveService.findByPage(receivePage);
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public ResponseMessage<Receive> save(Receive receive) {
        return new ResponseMessage(Boolean.valueOf(this.receiveService.saveOrUpdate((Object)receive)), (Object)receive);
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public ResponseMessage<Receive> delete(String[] ids) {
        return new ResponseMessage(Boolean.valueOf(this.receiveService.removeByIds(Arrays.asList(ids))));
    }

    @RequestMapping(value={"/receiveNo"})
    @ResponseBody
    public long receiveNo(String name, String year) {
        long no = 0L;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("receiveName", name);
        map.put("receiveYear", year);
        Object queryNo = this.receiveService.getMaxReceiveNo(map);
        no = queryNo == null ? 1L : (Long)queryNo;
        return no + 1L;
    }
}

