/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.controller;

import cn.gtmap.gtc.sso.domain.dto.OrganizationDto;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.model.Overtime;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.OvertimePage;
import com.gtis.oa.service.OvertimeService;
import com.gtis.oa.util.CommonUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/overtime"})
public class OvertimeController {
    @Autowired
    OvertimeService overtimeService;

    @RequestMapping(value={"/index"})
    public String index(Model model, String processInsId) {
        Overtime overtime = null;
        if (StringUtils.isNotBlank((String)processInsId)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", processInsId);
            overtime = this.overtimeService.findByMap(map);
        }
        if (overtime == null) {
            overtime = new Overtime();
            overtime.setOvertimeId(processInsId);
            overtime.setApplyTime(new Date());
            overtime.setApplyPeople(CommonUtil.getUser().getUsername());
            overtime.setApplyUnit(((OrganizationDto)CommonUtil.getUser().getOrgRecordList().get(0)).getName());
            this.overtimeService.save((Object)overtime);
        }
        model.addAttribute("overtime", (Object)overtime);
        return "officeapply/overtime/overtime_edit";
    }

    @RequestMapping(value={"/list"})
    public String list(Model model, String type) {
        model.addAttribute("type", (Object)type);
        return "officeapply/overtime/overtime_list";
    }

    @RequestMapping(value={"/findByPage"})
    @ResponseBody
    public IPage<Overtime> findByPage(OvertimePage overtimePage) {
        return this.overtimeService.findByPage(overtimePage);
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public ResponseMessage<Overtime> save(Overtime overtime) {
        return new ResponseMessage(Boolean.valueOf(this.overtimeService.saveOrUpdate((Object)overtime)), (Object)overtime);
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public ResponseMessage<Overtime> delete(String[] ids) {
        return new ResponseMessage(Boolean.valueOf(this.overtimeService.removeByIds(Arrays.asList(ids))));
    }
}

