/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.Message;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.MessagePage;
import com.gtis.oa.service.MessageService;
import com.gtis.oa.util.CommonUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/message"})
public class MessageController {
    @Autowired
    private MessageService messageService;

    @RequestMapping(value={"/index"})
    public String index(Model model, String proid, String accept) {
        Message message = null;
        if (StringUtils.isNotBlank((String)proid)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", proid);
            message = this.messageService.findByMap(map);
        }
        if (message == null) {
            message = new Message();
            message.setId(UUID.hex32());
            message.setIsPublished("\u672a\u53d1\u5e03");
            message.setCreateTime(new Date());
            this.messageService.save((Object)message);
        }
        model.addAttribute("message", (Object)message);
        if (StringUtils.isNotBlank((String)accept)) {
            model.addAttribute("accept", (Object)accept);
        }
        return "management/message/message_edit";
    }

    @RequestMapping(value={"/list"})
    public String list(String type) {
        if ("manage".equals(type)) {
            return "management/message/message_list";
        }
        return "management/message/message_list_view";
    }

    @RequestMapping(value={"/acceptList"})
    public String acceptList(Model model, String type) {
        model.addAttribute("userName", (Object)CommonUtil.getUsername());
        if ("manage".equals(type)) {
            return "management/message/message_acceptList";
        }
        return "management/message/message_acceptList_view";
    }

    @RequestMapping(value={"/findByPage"})
    @ResponseBody
    public IPage<Message> findByPage(MessagePage messagePage) {
        return this.messageService.findByPage(messagePage);
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public ResponseMessage<Message> save(Message message) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)message.getId()) && !"undefined".equals(message.getId())) {
            return new ResponseMessage(Boolean.valueOf(this.messageService.updateById((Object)message)), (Object)message);
        }
        message.setId(UUID.hex32());
        return new ResponseMessage(Boolean.valueOf(this.messageService.save((Object)message)), (Object)message);
    }

    @RequestMapping(value={"/saveRead"})
    @ResponseBody
    public ResponseMessage<Message> saveRead(String id) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        Message message = this.messageService.findByMap(map);
        message.setIsRead("1");
        return new ResponseMessage(Boolean.valueOf(this.messageService.updateById((Object)message)), (Object)message);
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public ResponseMessage<Message> delete(String[] ids) {
        return new ResponseMessage(Boolean.valueOf(this.messageService.removeByIds(Arrays.asList(ids))));
    }
}

