/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.Meetroom;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.MeetroomPage;
import com.gtis.oa.service.MeetroomService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/meetroom"})
public class MeetroomController {
    @Autowired
    MeetroomService meetroomService;

    @RequestMapping(value={"/list"})
    public String list(Model model) {
        return "management/meet/meetroom_list";
    }

    @RequestMapping(value={"/findByPage"})
    @ResponseBody
    public IPage<Meetroom> findByPage(MeetroomPage meetroomPage) {
        IPage list = null;
        try {
            list = this.meetroomService.findByPage(meetroomPage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    @RequestMapping(value={"/index"})
    public String index(Model model, String roomId) {
        Meetroom meetroom = null;
        if (StringUtils.isNotBlank((String)roomId)) {
            meetroom = (Meetroom)this.meetroomService.getById((Serializable)((Object)roomId));
        }
        if (meetroom == null) {
            meetroom = new Meetroom();
            meetroom.setRoomId(roomId);
        }
        model.addAttribute("meetroom", (Object)meetroom);
        return "management/meet/meetroom_edit";
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public ResponseMessage<Meetroom> save(Meetroom meetroom) {
        ResponseMessage a = null;
        try {
            if (StringUtils.isNotBlank((String)meetroom.getRoomId())) {
                a = new ResponseMessage(Boolean.valueOf(this.meetroomService.updateById((Object)meetroom)), (Object)meetroom);
            } else {
                meetroom.setRoomId(UUID.hex32());
                a = new ResponseMessage(Boolean.valueOf(this.meetroomService.save((Object)meetroom)), (Object)meetroom);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return a;
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public ResponseMessage<Meetroom> delete(String[] ids) {
        return new ResponseMessage(Boolean.valueOf(this.meetroomService.removeByIds(Arrays.asList(ids))));
    }

    @RequestMapping(value={"/getParentMeun"})
    @ResponseBody
    public List<Meetroom> getParentMeun() {
        MeetroomPage meetroomPage = new MeetroomPage();
        IPage list = this.meetroomService.findByPage(meetroomPage);
        List meetroomList = list.getRecords();
        return meetroomList;
    }
}

