/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.controller;

import cn.gtmap.common.utils.CalendarUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.common.utils.DateUtils;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.Meetroom;
import com.gtis.oa.model.MeetroomApply;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.MeetroomApplyPage;
import com.gtis.oa.model.page.MeetroomPage;
import com.gtis.oa.service.MeetroomApplyService;
import com.gtis.oa.service.MeetroomService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/meetroomApply"})
public class MeetroomApplyController {
    @Autowired
    MeetroomApplyService meetroomApplyService;
    @Autowired
    MeetroomService meetroomService;

    @RequestMapping(value={"/index"})
    public String index(Model model) {
        MeetroomPage meetroomPage = new MeetroomPage();
        IPage list = this.meetroomService.findByPage(meetroomPage);
        List meetroomList = list.getRecords();
        model.addAttribute("meetroomList", (Object)meetroomList);
        return "management/meet/meetroomApply_index";
    }

    @RequestMapping(value={"/goCalendarMeeting"})
    public String goCalendarMeeting(Model model, String roomId, String roomName) {
        model.addAttribute("roomId", (Object)roomId);
        model.addAttribute("roomName", (Object)roomName);
        return "management/meet/meetroomApply_calendar";
    }

    @RequestMapping(value={"/goMeetroomApply"})
    public String goMeetroomApply(Model model, String id, String roomId, Date clickDate) {
        MeetroomApply meetroomApply = null;
        if (StringUtils.isNotBlank((String)id)) {
            meetroomApply = (MeetroomApply)this.meetroomApplyService.getById((Serializable)((Object)id));
        }
        if (meetroomApply == null) {
            meetroomApply = new MeetroomApply();
            meetroomApply.setId(id);
            meetroomApply.setRoomId(roomId);
            meetroomApply.setMeetDate(CalendarUtil.formatDate((Date)clickDate));
            meetroomApply.setRoomName(((Meetroom)this.meetroomService.getById((Serializable)((Object)roomId))).getRoomName());
        }
        model.addAttribute("meetroomApply", (Object)meetroomApply);
        return "management/meet/meetroomApply_edit";
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public String save(MeetroomApply meetroomApply) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("msg", "\u9884\u5b9a\u6210\u529f\uff01");
        result.put("result", true);
        String save = "true";
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("ROOM_ID", meetroomApply.getRoomId());
            map.put("MEET_DATE", DateUtils.formatTime((Date)meetroomApply.getMeetDate(), (FastDateFormat)DateUtils.DATE_FORMAT));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            Date beginTime = sdf.parse(DateUtils.formatTime((Date)meetroomApply.getBeginTime(), (FastDateFormat)DateUtils.DATEMIN_FORMAT));
            Date endTime = sdf.parse(DateUtils.formatTime((Date)meetroomApply.getEndTime(), (FastDateFormat)DateUtils.DATEMIN_FORMAT));
            List oaMeetroomApplyList = this.meetroomApplyService.findByMap(map);
            if (CollectionUtils.isNotEmpty((Collection)oaMeetroomApplyList)) {
                for (int i = 0; i < oaMeetroomApplyList.size(); ++i) {
                    Date startTime = ((MeetroomApply)oaMeetroomApplyList.get(i)).getBeginTime();
                    Date finishTime = ((MeetroomApply)oaMeetroomApplyList.get(i)).getEndTime();
                    if (!(beginTime.after(startTime) && endTime.before(finishTime) || endTime.after(startTime) && endTime.before(finishTime) || beginTime.before(startTime) && endTime.after(finishTime)) && !beginTime.before(finishTime)) continue;
                    result.put("msg", "\u6b64\u65f6\u95f4\u6bb5\u8be5\u4f1a\u8bae\u5ba4\u5df2\u6709\u9884\u5b9a\uff01\u5982\u9047\u9884\u5b9a\u51b2\u7a81\uff0c\u53ca\u65f6\u7ba1\u7406\u5458\u8fdb\u884c\u534f\u8c03\uff01");
                    result.put("result", false);
                    save = "false";
                }
            }
            if ("true".equals(save)) {
                if (StringUtils.isNotBlank((String)meetroomApply.getId())) {
                    this.meetroomApplyService.updateById((Object)meetroomApply);
                } else {
                    meetroomApply.setId(UUID.hex32());
                    this.meetroomApplyService.save((Object)meetroomApply);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return JSON.toJSONString(result);
    }

    @RequestMapping(value={"/getMeetroomApplyEvents"})
    @ResponseBody
    public Object getMeetroomApplyEvents(String roomId) throws Exception {
        StringBuffer outStr = new StringBuffer();
        outStr.append("[");
        try {
            MeetroomApplyPage meetroomApplyPage = new MeetroomApplyPage();
            meetroomApplyPage.setRoomId(roomId);
            IPage oaMeetroomApplyIPage = this.meetroomApplyService.findByPage(meetroomApplyPage);
            List oaMeetroomApplyList = oaMeetroomApplyIPage.getRecords();
            if (CollectionUtils.isNotEmpty((Collection)oaMeetroomApplyList)) {
                for (MeetroomApply oaMeetroomApply : oaMeetroomApplyList) {
                    outStr.append("{");
                    outStr.append("title : \"\u4f1a\u8bae\u5ba4:" + oaMeetroomApply.getRoomName() + ";");
                    outStr.append("\\n");
                    outStr.append("\u9884\u5b9a\u90e8\u95e8:" + oaMeetroomApply.getApplyUnit() + ";");
                    outStr.append("\\n");
                    outStr.append("\u9884\u8ba2\u4eba:" + oaMeetroomApply.getApplyPeople() + ";");
                    outStr.append("\\n");
                    outStr.append("\u4f1a\u8bae\u4e3b\u9898:" + oaMeetroomApply.getMeetTheme() + ";");
                    outStr.append("\",");
                    outStr.append("start : \"" + DateUtils.formatTime((Date)oaMeetroomApply.getBeginTime(), (FastDateFormat)DateUtils.DATEMIN_FORMAT) + "\",");
                    outStr.append("end: \"" + DateUtils.formatTime((Date)oaMeetroomApply.getEndTime(), (FastDateFormat)DateUtils.DATEMIN_FORMAT) + "\",");
                    outStr.append("id: '" + oaMeetroomApply.getId() + "',");
                    outStr.append("allDay: false,");
                    outStr.append("meetroomId: '" + roomId + "'");
                    outStr.append("},");
                }
                outStr = outStr.deleteCharAt(outStr.lastIndexOf(","));
                outStr.append("]");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return outStr.toString();
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public ResponseMessage<MeetroomApply> delete(String id) {
        return new ResponseMessage(Boolean.valueOf(this.meetroomApplyService.removeById((Serializable)((Object)id))));
    }
}

