/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.controller;

import cn.gtmap.gtc.sso.domain.dto.OrganizationDto;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.model.Loan;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.LoanPage;
import com.gtis.oa.service.LoanService;
import com.gtis.oa.util.CommonUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/loan"})
public class LoanController {
    @Autowired
    LoanService loanService;

    @RequestMapping(value={"/index"})
    public String index(Model model, String processInsId) {
        Loan loan = null;
        if (StringUtils.isNotBlank((String)processInsId)) {
            loan = (Loan)this.loanService.getById((Serializable)((Object)processInsId));
        }
        if (loan == null) {
            loan = new Loan();
            loan.setId(processInsId);
            loan.setApplyTime(new Date());
            loan.setApplyPeople(CommonUtil.getUser().getUsername());
            loan.setApplyUnit(((OrganizationDto)CommonUtil.getUser().getOrgRecordList().get(0)).getName());
            this.loanService.save((Object)loan);
        }
        model.addAttribute("loan", (Object)loan);
        return "officeapply/loan/loan_edit";
    }

    @RequestMapping(value={"/list"})
    public String list(Model model, String type) {
        model.addAttribute("type", (Object)type);
        return "officeapply/loan/loan_list";
    }

    @RequestMapping(value={"/findByPage"})
    @ResponseBody
    public IPage<Loan> findByPage(LoanPage loanPage) {
        return this.loanService.findByPage(loanPage);
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public ResponseMessage<Loan> save(Loan loan) {
        return new ResponseMessage(Boolean.valueOf(this.loanService.saveOrUpdate((Object)loan)), (Object)loan);
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public ResponseMessage<Loan> delete(String[] ids) {
        return new ResponseMessage(Boolean.valueOf(this.loanService.removeByIds(Arrays.asList(ids))));
    }
}

