/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.controller;

import com.alibaba.fastjson.JSON;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.LawsType;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.service.LawsTypeService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/lawsType"})
public class LawsTypeController {
    @Autowired
    LawsTypeService lawsTypeService;

    @RequestMapping(value={"/index"})
    public String index(Model model) {
        return "management/laws/lawstype_tree";
    }

    @RequestMapping(value={"getLawsTypeList"})
    @ResponseBody
    public List<LawsType> getLawsTypeList(HttpServletRequest request, HttpServletResponse response) {
        HashMap map = new HashMap();
        List lawsTypeList = this.lawsTypeService.getLawsTypeList(map);
        return lawsTypeList;
    }

    @RequestMapping(value={"save"})
    public ResponseMessage<LawsType> save(LawsType lawsType, String ftypeParentId, HttpServletRequest request, HttpServletResponse response) {
        ResponseMessage msg = null;
        try {
            Integer sort = 0;
            String typeId = lawsType.getTypeId();
            if (StringUtils.isNotBlank((String)typeId)) {
                LawsType temp = (LawsType)this.lawsTypeService.getById((Serializable)((Object)typeId));
                temp.setFname(lawsType.getFname());
                temp.setFmemo(lawsType.getFmemo());
                temp.setIsUse(lawsType.getIsUse());
                List nodeIdList = this.lawsTypeService.findNodeIdById(typeId);
                if (CollectionUtils.isNotEmpty((Collection)nodeIdList)) {
                    for (String nodeId : nodeIdList) {
                        LawsType nodeTemp = (LawsType)this.lawsTypeService.getById((Serializable)((Object)nodeId));
                        nodeTemp.setFtypeParentName(lawsType.getFname());
                        nodeTemp.setIsUse(lawsType.getIsUse());
                        this.lawsTypeService.updateById((Object)nodeTemp);
                    }
                }
                msg = new ResponseMessage(Boolean.valueOf(this.lawsTypeService.updateById((Object)temp)), (Object)temp);
            } else {
                typeId = UUID.hex32();
                lawsType.setTypeId(typeId);
                HashMap<String, String> map = new HashMap<String, String>();
                if (StringUtils.isNotBlank((String)ftypeParentId)) {
                    map.put("ftypeParentId", ftypeParentId);
                    sort = this.lawsTypeService.findMaxSort(map);
                    if (sort == null) {
                        lawsType.setFtypeParentId(ftypeParentId);
                        lawsType.setSort(Integer.valueOf(1));
                    } else {
                        lawsType.setFtypeParentId(ftypeParentId);
                        sort = sort + 1;
                        lawsType.setSort(sort);
                    }
                } else {
                    map.put("ftypeParentId", "-1");
                    sort = this.lawsTypeService.findMaxSort(map);
                    if (sort == null) {
                        lawsType.setSort(Integer.valueOf(1));
                        lawsType.setFtypeParentId("-1");
                    } else {
                        sort = sort + 1;
                        lawsType.setSort(sort);
                        lawsType.setFtypeParentId("-1");
                    }
                }
                msg = new ResponseMessage(Boolean.valueOf(this.lawsTypeService.save((Object)lawsType)), (Object)lawsType);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return msg;
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public String delete(@RequestParam(name="typeId", required=false) String typeId, @RequestParam(name="ftypeParentId", required=false) String ftypeParentId, @RequestParam(name="sort", required=false) Integer sort, HttpServletRequest request, HttpServletResponse response) {
        String result = "success";
        List listNode = new ArrayList();
        ArrayList<LawsType> lawsTypeList = new ArrayList<LawsType>();
        try {
            List idList = this.lawsTypeService.findNodeIdById(typeId);
            listNode = this.lawsTypeService.findDyXh(ftypeParentId, sort);
            if (listNode.size() > 0) {
                for (Map node : listNode) {
                    LawsType lawsType = new LawsType();
                    lawsType.setTypeId(node.get("TYPE_ID").toString());
                    BigDecimal nodesort = (BigDecimal)node.get("SORT");
                    int intNodeSort = nodesort.intValue();
                    lawsType.setSort(Integer.valueOf(--intNodeSort));
                    lawsTypeList.add(lawsType);
                }
            }
            this.lawsTypeService.removeById((Serializable)((Object)typeId));
            if (lawsTypeList.size() > 0) {
                for (LawsType lawsType : lawsTypeList) {
                    this.lawsTypeService.saveOrUpdate((Object)lawsType);
                }
            }
            this.lawsTypeService.removeByIds((Collection)idList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return JSON.toJSONString((Object)result);
    }

    @RequestMapping(value={"/getParentMeun"})
    @ResponseBody
    public List<LawsType> getParentMeun() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("isUse", "\u662f");
        List list = this.lawsTypeService.getLawsTypeList(map);
        ArrayList<LawsType> rootMeun = new ArrayList<LawsType>();
        for (LawsType lawsType : list) {
            if (!"-1".equals(lawsType.getFtypeParentId())) continue;
            rootMeun.add(lawsType);
        }
        for (LawsType temp : rootMeun) {
            List childrenList = this.getchildrenMeun(temp.getTypeId(), list);
            temp.setChildrenList(childrenList);
        }
        return rootMeun;
    }

    private List<LawsType> getchildrenMeun(String typeId, List<LawsType> allMeun) {
        ArrayList<LawsType> childrenList = new ArrayList<LawsType>();
        for (LawsType lawsType : allMeun) {
            if (!lawsType.getFtypeParentId().equals(typeId)) continue;
            childrenList.add(lawsType);
        }
        for (LawsType info : childrenList) {
            info.setChildrenList(this.getchildrenMeun(info.getTypeId(), allMeun));
        }
        if (childrenList != null && childrenList.size() == 0) {
            return null;
        }
        return childrenList;
    }

    @RequestMapping(value={"/saveTreeLawsType"})
    public void saveTreeLawsType() {
        String url = "http://f.mnr.gov.cn/";
        try {
            Map map = this.lawsTypeService.getLawsTypeWithUrl(url);
            for (String key : map.keySet()) {
                String value = (String)map.get(key);
                String[] values = value.split(",");
                LawsType lawsType = (LawsType)this.lawsTypeService.getById((Serializable)((Object)key));
                if (lawsType != null) continue;
                LawsType lawsTypeNew = new LawsType();
                lawsTypeNew.setTypeId(key);
                lawsTypeNew.setFmemo(values[1]);
                lawsTypeNew.setFname(values[1]);
                lawsTypeNew.setFtypeParentId(values[0]);
                lawsTypeNew.setIsUse("\u662f");
                lawsTypeNew.setSort(Integer.valueOf(Integer.parseInt(key)));
                this.lawsTypeService.saveOrUpdate((Object)lawsTypeNew);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

