/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.controller;

import cn.gtmap.gtc.clients.UserManagerClient;
import cn.gtmap.gtc.sso.domain.dto.OrganizationDto;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import cn.gtmap.gtc.storage.clients.v1.StorageClient;
import cn.gtmap.gtc.storage.domain.dto.StorageDto;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.model.Dispatch;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.DispatchPage;
import com.gtis.oa.service.DispatchService;
import com.gtis.oa.util.MacroUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/dispatch"})
public class DispatchController {
    @Autowired
    DispatchService dispatchService;
    @Autowired
    StorageClient storageClient;
    @Autowired
    UserManagerClient userManagerClient;

    @RequestMapping(value={"/index"})
    public String index(Model model, String processInsId) {
        Dispatch dispatch = null;
        if (StringUtils.isNotBlank((String)processInsId)) {
            dispatch = (Dispatch)this.dispatchService.getById((Serializable)((Object)processInsId));
        }
        if (dispatch == null) {
            dispatch = new Dispatch();
            dispatch.setDispatchId(processInsId);
            Calendar calendar = Calendar.getInstance();
            int year = calendar.get(1);
            dispatch.setDispatchYear(year + "");
            dispatch.setDraftDate(new Date());
            this.dispatchService.save((Object)dispatch);
        }
        String clientId = "officeAut";
        StorageDto storageDto = this.storageClient.createRootFolder(clientId, processInsId, "\u53d1\u6587\u6b63\u6587", null);
        model.addAttribute("dispatch", (Object)dispatch);
        return "document/dispatch/dispatch_edit";
    }

    @RequestMapping(value={"/list"})
    public String list() {
        return "document/dispatch/dispatch_list";
    }

    @RequestMapping(value={"/viewList"})
    public String viewList() {
        return "document/dispatch/dispatch_list_view";
    }

    @RequestMapping(value={"/findByPage"})
    @ResponseBody
    public IPage<Dispatch> findByPage(DispatchPage dispatchPage) {
        return this.dispatchService.findByPage(dispatchPage);
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public ResponseMessage<Dispatch> save(Dispatch dispatch) {
        return new ResponseMessage(Boolean.valueOf(this.dispatchService.saveOrUpdate((Object)dispatch)), (Object)dispatch);
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public ResponseMessage<Dispatch> delete(String[] ids) {
        return new ResponseMessage(Boolean.valueOf(this.dispatchService.removeByIds(Arrays.asList(ids))));
    }

    @RequestMapping(value={"/dispatchNo"})
    @ResponseBody
    public long dispatchNo(String name, String year) {
        long no = 0L;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("dispatchName", name);
        map.put("dispatchYear", year);
        Object queryNo = this.dispatchService.getMaxDispatchNo(map);
        no = queryNo == null ? 1L : (Long)queryNo;
        return no + 1L;
    }

    @RequestMapping(value={"/content"})
    public String content(Model model, String processInsId, HttpServletRequest request) throws Exception {
        processInsId = "335891";
        String unitName = "";
        String clientId = "officeAut";
        List file = null;
        ArrayList files = new ArrayList();
        List folders = this.storageClient.listAllRootStorages(clientId, processInsId, null, null, null, Integer.valueOf(0));
        if (folders != null && !folders.isEmpty()) {
            for (StorageDto folder : folders) {
                if (!folder.getName().equals("\u53d1\u6587\u6b63\u6587")) continue;
                file = this.storageClient.listAllSubsetStorages(folder.getId(), null, null, Integer.valueOf(1));
                files.add(file.get(0));
            }
        }
        String docfileName = "";
        String docfid = "";
        String cebfid = "";
        String cebfileName = null;
        if (files != null) {
            for (StorageDto f : files) {
                if (f.getName().toLowerCase().endsWith(".doc") || f.getName().toLowerCase().endsWith(".docx")) {
                    docfid = f.getId();
                    docfileName = f.getName();
                }
                if (!f.getName().toLowerCase().endsWith(".ceb")) continue;
                cebfid = f.getId();
                cebfileName = f.getName();
            }
        }
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/";
        model.addAttribute("basePath", (Object)basePath);
        model.addAttribute("unitName", (Object)unitName);
        model.addAttribute("docfileName", (Object)docfileName);
        model.addAttribute("docfid", (Object)docfid);
        model.addAttribute("cebfid", (Object)cebfid);
        model.addAttribute("cebfileName", (Object)cebfileName);
        Dispatch dispatch = (Dispatch)this.dispatchService.getById((Serializable)((Object)processInsId));
        if (dispatch == null) {
            dispatch = new Dispatch();
        }
        model.addAttribute("dispatch", (Object)dispatch);
        model.addAttribute("macroStr", (Object)MacroUtil.parseTemplet((Dispatch)dispatch, (String)basePath));
        String redhead = "";
        model.addAttribute("redhead", (Object)redhead);
        UserDto userDto = this.userManagerClient.getCurrentUser();
        String userName = userDto.getUsername();
        List userDptList = userDto.getOrgRecordList();
        String userDpt = ((OrganizationDto)userDptList.get(0)).getName();
        model.addAttribute("loginuser", (Object)userName);
        model.addAttribute("userDpt", (Object)userDpt);
        model.addAttribute("proid", (Object)processInsId);
        model.addAttribute("author", (Object)this.checkPlatformAuthor(processInsId));
        return "document/dispatch/dispatch_content";
    }

    public Map checkPlatformAuthor(String proid) {
        HashMap<String, String> paraMap = new HashMap<String, String>();
        paraMap.put("proid", proid);
        paraMap.put("saveCtrl", "TRUE");
        paraMap.put("canExecMacro", "TRUE");
        paraMap.put("canImport", "FALSE");
        paraMap.put("canTransCEB", "FALSE");
        paraMap.put("IsRecMark", "FALSE");
        paraMap.put("canSaveas", "FALSE");
        return paraMap;
    }

    @RequestMapping(value={"onlyoffice"})
    public String onlyoffice(Model model, String processInsId) throws Exception {
        String fileName;
        String clientId = "officeAut";
        List file = null;
        ArrayList files = new ArrayList();
        List folders = this.storageClient.listAllRootStorages(clientId, processInsId, null, null, null, Integer.valueOf(0));
        if (folders != null && !folders.isEmpty()) {
            for (StorageDto folder : folders) {
                if (!folder.getName().equals("\u53d1\u6587\u6b63\u6587")) continue;
                file = this.storageClient.listAllSubsetStorages(folder.getId(), null, null, Integer.valueOf(1));
                files.add(file.get(0));
            }
        }
        if (CollectionUtils.isNotEmpty(files)) {
            model.addAttribute("url", (Object)((StorageDto)files.get(0)).getDownUrl());
            fileName = ((StorageDto)files.get(0)).getName();
            String name = fileName.substring(0, fileName.lastIndexOf("."));
            String type = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
            model.addAttribute("name", (Object)name);
            model.addAttribute("type", (Object)type);
        } else {
            model.addAttribute("url", (Object)"http://192.168.8.118:7000/oa/static/blank.docx");
            fileName = "blank.docx";
            model.addAttribute("name", (Object)"blank");
            model.addAttribute("type", (Object)"docx");
        }
        return "document/dispatch/only_office";
    }
}

