/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.Car;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.CarPage;
import com.gtis.oa.service.CarService;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/car"})
public class CarController {
    @Autowired
    CarService carService;

    @RequestMapping(value={"/list"})
    public String list(Model model, String type) {
        model.addAttribute("type", (Object)type);
        return "officeapply/useCar/car_list";
    }

    @RequestMapping(value={"/findByPage"})
    @ResponseBody
    public IPage<Car> findByPage(CarPage carPage) {
        IPage list = null;
        try {
            list = this.carService.findByPage(carPage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    @RequestMapping(value={"/index"})
    public String indexCar(Model model, String id) {
        Car car = null;
        if (StringUtils.isNotBlank((String)id)) {
            car = (Car)this.carService.getById((Serializable)((Object)id));
        }
        if (car == null) {
            car = new Car();
            car.setCarId(UUID.hex32());
        }
        model.addAttribute("car", (Object)car);
        return "officeapply/useCar/car_edit";
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public ResponseMessage<Car> save(Car car) {
        return new ResponseMessage(Boolean.valueOf(this.carService.saveOrUpdate((Object)car)), (Object)car);
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public ResponseMessage<Car> delete(String[] ids) {
        return new ResponseMessage(Boolean.valueOf(this.carService.removeByIds(Arrays.asList(ids))));
    }
}

