/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.common.collect.Maps;
import com.gtis.oa.model.Asset;
import com.gtis.oa.model.AssetAttachment;
import com.gtis.oa.model.AssetModel;
import com.gtis.oa.model.OaDict;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.AssetPage;
import com.gtis.oa.service.AssetAttachmentService;
import com.gtis.oa.service.AssetService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/asset"})
public class AssetController {
    private static final Logger log = LoggerFactory.getLogger(AssetController.class);
    @Autowired
    AssetService assetService;
    @Autowired
    AssetAttachmentService assetAttachmentService;

    @RequestMapping(value={"/index"})
    public String index(Model model, String processInsId) {
        Asset asset = null;
        if (StringUtils.isNotBlank((String)processInsId)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", processInsId);
            asset = this.assetService.findByMap(map);
        }
        if (asset == null) {
            asset = new Asset();
            asset.setId(processInsId);
            asset.setApplyTime(new Date());
        }
        model.addAttribute("asset", (Object)asset);
        model.addAttribute("proid", (Object)processInsId);
        OaDict oaDict = new OaDict();
        oaDict.setName("\u529e\u516c\u8bbe\u5907");
        OaDict oaDict1 = new OaDict();
        oaDict1.setName("\u529e\u516c\u7535\u5668");
        ArrayList<OaDict> wpType = new ArrayList<OaDict>();
        wpType.add(oaDict);
        wpType.add(oaDict1);
        model.addAttribute("wpType", wpType);
        OaDict oaDict2 = new OaDict();
        oaDict2.setId("\u529e\u516c\u8bbe\u5907");
        oaDict2.setName("\u7535\u8111");
        OaDict oaDict3 = new OaDict();
        oaDict3.setId("\u529e\u516c\u8bbe\u5907");
        oaDict3.setName("\u8003\u52e4\u673a");
        ArrayList<OaDict> sbmc = new ArrayList<OaDict>();
        sbmc.add(oaDict2);
        sbmc.add(oaDict3);
        model.addAttribute("sbmc", sbmc);
        OaDict oaDict4 = new OaDict();
        oaDict4.setId("\u529e\u516c\u7535\u5668");
        oaDict4.setName("\u7535\u98ce\u6247");
        OaDict oaDict5 = new OaDict();
        oaDict5.setId("\u529e\u516c\u7535\u5668");
        oaDict5.setName("\u7a7a\u8c03");
        ArrayList<OaDict> dqmc = new ArrayList<OaDict>();
        dqmc.add(oaDict4);
        dqmc.add(oaDict5);
        model.addAttribute("dqmc", dqmc);
        return "officeapply/asset/asset_edit";
    }

    @RequestMapping(value={"/getDictByType"})
    @ResponseBody
    public List<OaDict> getDictByType(String dictId) {
        ArrayList<OaDict> mc = new ArrayList<OaDict>();
        if (dictId.equals("\u529e\u516c\u7535\u5668")) {
            OaDict oaDict4 = new OaDict();
            oaDict4.setId("\u529e\u516c\u7535\u5668");
            oaDict4.setName("\u7535\u98ce\u6247");
            OaDict oaDict5 = new OaDict();
            oaDict5.setId("\u529e\u516c\u7535\u5668");
            oaDict5.setName("\u7a7a\u8c03");
            mc.add(oaDict4);
            mc.add(oaDict5);
        } else {
            OaDict oaDict2 = new OaDict();
            oaDict2.setId("\u529e\u516c\u8bbe\u5907");
            oaDict2.setName("\u7535\u8111");
            OaDict oaDict3 = new OaDict();
            oaDict3.setId("\u529e\u516c\u8bbe\u5907");
            oaDict3.setName("\u8003\u52e4\u673a");
            mc.add(oaDict2);
            mc.add(oaDict3);
        }
        return mc;
    }

    @RequestMapping(value={"/list"})
    public String list(Model model, String type) {
        model.addAttribute("type", (Object)type);
        return "officeapply/asset/asset_list";
    }

    @RequestMapping(value={"/findByPage"})
    @ResponseBody
    public IPage<Object> findByPage(AssetPage assetPage) {
        return this.assetService.findByPage(assetPage);
    }

    @RequestMapping(value={"/assetList"})
    @ResponseBody
    public List<AssetAttachment> assetList(String proid) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", proid);
        ArrayList assetAttachmentList = this.assetAttachmentService.findByMap(map);
        if (assetAttachmentList.size() == 0) {
            assetAttachmentList = new ArrayList(1);
        }
        return assetAttachmentList;
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public ResponseMessage<Asset> delete(String[] ids) {
        return new ResponseMessage(Boolean.valueOf(this.assetService.removeByIds(Arrays.asList(ids))));
    }

    @RequestMapping(value={"/deleteAtt"})
    @ResponseBody
    public ResponseMessage<AssetAttachment> deleteAtt(String[] ids) {
        return new ResponseMessage(Boolean.valueOf(this.assetAttachmentService.removeByIds(Arrays.asList(ids))));
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public Map<String, Object> save(AssetModel assetModel) {
        boolean result = false;
        String msg = "\u64cd\u4f5c\u5931\u8d25\uff01";
        if (assetModel != null) {
            try {
                this.assetAttachmentService.saveAsset(assetModel);
                result = true;
                msg = "\u64cd\u4f5c\u6210\u529f\uff01";
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        map.put("result", result);
        map.put("msg", msg);
        return map;
    }
}

