/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@Order(value=1)
public class MyBatisConfig {
    @Autowired
    private Environment env;
    @Autowired
    private PaginationInterceptor paginationInterceptor;

    @Bean
    public DataSource getDataSource() {
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setUrl(this.env.getProperty("spring.datasource.url"));
        dataSource.setUsername(this.env.getProperty("spring.datasource.username"));
        dataSource.setPassword(this.env.getProperty("spring.datasource.password"));
        return dataSource;
    }

    @Bean(name={"sqlSessionFactory"})
    public SqlSessionFactory sqlSessionFactoryBean() {
        MybatisSqlSessionFactoryBean bean = new MybatisSqlSessionFactoryBean();
        bean.setDataSource(this.getDataSource());
        bean.setTypeAliasesPackage("com.gtis.oa.model");
        bean.setPlugins(new Interceptor[]{this.paginationInterceptor});
        Properties configurationProperties = new Properties();
        configurationProperties.setProperty("logImpl", "STDOUT_LOGGING");
        configurationProperties.setProperty("cacheEnabled", "false");
        configurationProperties.setProperty("callSettersOnNulls", "true");
        configurationProperties.setProperty("lazyLoadingEnabled", "true");
        configurationProperties.setProperty("aggressiveLazyLoading", "false");
        configurationProperties.setProperty("multipleResultSetsEnabled", "true");
        configurationProperties.setProperty("useColumnLabel", "true");
        configurationProperties.setProperty("useGeneratedKeys", "false");
        configurationProperties.setProperty("autoMappingBehavior", "PARTIAL");
        configurationProperties.setProperty("defaultExecutorType", "SIMPLE");
        configurationProperties.setProperty("defaultStatementTimeout", "25000");
        configurationProperties.setProperty("safeRowBoundsEnabled", "false");
        configurationProperties.setProperty("mapUnderscoreToCamelCase", "true");
        configurationProperties.setProperty("localCacheScope", "SESSION");
        configurationProperties.setProperty("jdbcTypeForNull", "NULL");
        configurationProperties.setProperty("lazyLoadTriggerMethods", "equals,clone,hashCode,toString");
        bean.setConfigurationProperties(configurationProperties);
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            bean.setMapperLocations(resolver.getResources("classpath*:mybatis/*.xml"));
            return bean.getObject();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

