package com.gtis.gserver.web;

import com.gtis.gserver.gwc.Wms;
import com.gtis.gserver.model.ArcgisLayer;
import com.gtis.gserver.service.LayerManager;
import org.apache.commons.lang.StringUtils;
import org.geowebcache.arcgis.layer.ArcGISCacheLayer;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.service.OWSException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-6-20
 */
@Controller
@RequestMapping(value = "console")
public class ConsoleController {

    @Autowired
    private LayerManager layerManager;
    @Autowired
    private TileLayerDispatcher tileLayerDispatcher;
    @Autowired
    private GridSetBroker gridSetBroker;

    @RequestMapping(method = RequestMethod.GET)
    public String index(Model model) {
        model.addAttribute("tab", "console");
        model.addAttribute("layers", layerManager.getLayers());
        return "console";
    }

    @RequestMapping(value = "reload")
    public String reload() {
        layerManager.reload();
        return "redirect:/console";
    }

    @RequestMapping(value = "edit", method = RequestMethod.POST)
    public String edit(Model model, ArcgisLayer arcgisLayer) {
        try {
            layerManager.saveLayer(arcgisLayer);
            success(model);
        } catch (IOException e) {
            failed(model, e.getMessage());
            model.addAttribute("layer", arcgisLayer);
            return "edit";
        }
        return "redirect:/console";
    }

    @RequestMapping(value = "edit", method = RequestMethod.GET)
    public String doEdit0(Model model) {
        return doEdit(model, null);
    }

    @RequestMapping(value = "edit/{id}")
    public String doEdit(Model model, @PathVariable String id) {
        model.addAttribute("layer", StringUtils.isBlank(id) ? new ArcgisLayer() : new ArcgisLayer((ArcGISCacheLayer) layerManager.getLayer(id)));
        return "edit";
    }

    @RequestMapping(value = "remove/{id}")
    public String remove(@PathVariable String id) {
        layerManager.removeLayer(id);
        return "redirect:/console";
    }

    @RequestMapping(value = "start/{id}")
    public String start(RedirectAttributes ra,@PathVariable String id) {
        try {
            layerManager.startLayer(id);
        } catch (RuntimeException e) {
            ra.addFlashAttribute("msg", e.getMessage());
        }
        return "redirect:/console";
    }

    @RequestMapping(value = "stop/{id}")
    public String stop(@PathVariable String id) {
        layerManager.stopLayer(id);
        return "redirect:/console";
    }

    @ResponseBody
    @RequestMapping(value = "wms/{id}")
    public void wms(@PathVariable("id") String id, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TileLayer layer = layerManager.getLayer(id);
        if (layer == null || !layer.isEnabled()) {
            throw new OWSException(400, "InvalidParameterValue", "LAYERS", "Layer '" + id + "' is disabled");
        }
        Wms.makeMap(tileLayerDispatcher, gridSetBroker, id, request, response);
    }

    protected Model success(Model model) {
        return model.addAttribute("ret", true);
    }

    protected Model failed(Model model, String msg) {
        model.addAttribute("msg", msg);
        return model.addAttribute("ret", false);
    }
}
