package com.gtis.gserver.model;

import org.geowebcache.arcgis.layer.ArcGISCacheLayer;
import org.geowebcache.grid.BoundingBox;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-6-20
 */
public class ArcgisLayer {
    private String id;
    private String srcId;
    private int order;
    private String path;
    private Double xmin;
    private Double ymin;
    private Double xmax;
    private Double ymax;

    public ArcgisLayer() {
    }

    public ArcgisLayer(ArcGISCacheLayer al) {
        srcId = id = al.getName();
        path = al.getTilingScheme().getAbsolutePath();
        xmin = al.getLayerBounds().getMinX();
        ymin = al.getLayerBounds().getMinY();
        xmax = al.getLayerBounds().getMaxX();
        ymax = al.getLayerBounds().getMaxY();
        order = al.getOrder();
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSrcId() {
        return srcId;
    }

    public void setSrcId(String srcId) {
        this.srcId = srcId;
    }

    public int getOrder() {
        return order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Double getXmin() {
        return xmin;
    }

    public void setXmin(Double xmin) {
        this.xmin = xmin;
    }

    public Double getYmin() {
        return ymin;
    }

    public void setYmin(Double ymin) {
        this.ymin = ymin;
    }

    public Double getXmax() {
        return xmax;
    }

    public void setXmax(Double xmax) {
        this.xmax = xmax;
    }

    public Double getYmax() {
        return ymax;
    }

    public void setYmax(Double ymax) {
        this.ymax = ymax;
    }

    public BoundingBox toBoundingBox() {
        if (xmin == null || ymin == null || xmax == null || ymax == null)
            return null;
        return new BoundingBox(xmin, ymin, xmax, ymax);
    }
}
