<@com.html title="抵押到期" import="jquery,bootstrap,highcharts,ext,base">
<script type="text/javascript">
    var store, gridPanel;
    Ext.require([
        'Ext.grid.*',
        'Ext.data.*',
        'Ext.util.*',
        'Ext.toolbar.Paging',
        'Ext.ModelManager',
        'Ext.tip.QuickTipManager',
        'Ext.form.field.Checkbox'
    ]);

    var rowEditing = Ext.create('Ext.grid.plugin.RowEditing', {
        clicksToMoveEditor: 1,
        autoCancel: false,
        pluginId:'rowEditing',
        saveBtnText: '保存',
        cancelBtnText: "取消"
    });

    rowEditing.on({
        scope: this,
        cancelEdit: function(e) {
            console.log("user clicked the cancel button");
        },
        edit:function(editor,changes){
            console.log("complete button");
            var myMask = new Ext.LoadMask(Ext.getBody(), {
                msg: '正在修改，请稍后...',
                removeMask: true
            });
            myMask.show();
            var params = changes.record.data;
            $.ajax({

                url: "/emapserver/warn/warn!update.action?type=${type!}",
                data: {
                    djdk: JSON.stringify(params)
                },
                success: function (response,_s) {
                    var result = JSON.parse(response);
                    myMask.hide();
                    if(result.success)
                    {
                        alert(result.msg);
                    }else
                    {
                        alert(result.msg);
                    }
                    store.load();
                },
                failure: function (response, opts) {

                    myMask.hide();
                    alert(response);
                }
            });
        }
    });

    var pageSize=parseInt((Ext.getBody().getViewSize().height-135)/20);
    var minHeight = Ext.getBody().getViewSize().height-135;

    Ext.onReady(function(){
        Ext.tip.QuickTipManager.init();

        store = new Ext.data.Store({
            pageSize:pageSize,
            model:'djdkModel',
            remoteSort:true,
            proxy:{
                type:'ajax',
                url:'warn!list.action?type='+'${type!}',
                reader:{
                    type:'json',
                    root:'items',
                    totalProperty:'totalCount'
                }
            },
            autoLoad:true
        });

        gridPanel = new Ext.grid.Panel({
            percentageWidths:100,
            percentageHeights:100,
            minHeight:minHeight,
            selModel:cbSelModel,
            multiSelect:true,
            store:store,
            stateful:true,
            columns:[
                {text:'id', dataIndex:'objectId', width:100,hidden:true},
                {text:'图形定位', width:80, renderer:mapRenderer,sortable:false},
//                {text:'到期提醒',dataIndex:'dydqsj',width:50,renderer:warnMe},
                {text:'单位名称', dataIndex:'dwmc1', width:100},
                {text:'土地坐落', dataIndex:'tdzl', width:100},
                {id:'tip1',text:'抵押类型', dataIndex:'dylx', width:100,
                    field:{
                        xtype:'textfield'
                    }},
                {text:'抵押金额', dataIndex:'dyje', width:100,
                field:{
                    xtype:'textfield'
                }},
                {text:'抵押到期时间', dataIndex:'dydqsj', width:100,renderer:dateFormat,
                    field: {
                        xtype: 'datefield',
                        format: 'Y年m月d',
                        submitFormat:'Y-m-d'
//                        maxValue: Ext.Date.format(new Date(), 'Y年m月d')
                    }
                }
            ],
            renderTo:'grid',
            viewConfig:{
                stripeRows:true,
                trackOver:false,
                id:'idleLandGrid'
            },
            bbar: Ext.create('Ext.PagingToolbar', {
                store: store,
                displayInfo: true,
                displayMsg: '显示第 {0}至{1}条/共 {2}记录',
                emptyMsg: "尚未检测到数据"
            }),
            tbar: Ext.create('Ext.toolbar.Toolbar', {
                items:[
//                    {
//                        text: '导出报表',
//                        xtype: 'button',
//                        iconCls: 'export',
//                        width: 75,
//                        listeners:{
//                            click:function(){
//                            }
//                        }
//                    },
                    '->',
                    {
                        xtype:'textfield',
                        name:'searchField',
                        hideLabel:true,
                        emptyText:'快速检索',
                        listeners:{
                            change:function () {
                                onSearch(gridPanel);
                            }
                        }
                    }

                ]
            }),
            plugins: [rowEditing]

        });

        Ext.create('Ext.tip.ToolTip', {
            target:gridPanel.getView().el,
            delegate: gridPanel.getView().itemSelector,
            trackMouse: true,
            html: '双击编辑'
        });

    });
    /**
     *  格式化时间显示样式
     * @param val
     */
    function dateFormat(val) {
        if (val) {
            if (navigator.userAgent.toLowerCase().indexOf("chrome") > -1)
                return Ext.util.Format.date(new Date(val), "Y年m月d日H:i:s");
            else
                return Ext.util.Format.date(new Date(Date.parse(val.replace(/-/g, "/"))), "Y年m月d日H:i:s");
        }
        else return "";
    }
    /**
     * 融资抵押到期的预警
     * @param val
     */
    function warnMe(val){
        if(val)
        {
            var date;
            var current_date=new Date();
            if (navigator.userAgent.toLowerCase().indexOf("chrome") > -1)
                date = new Date(val)
            else
                date = new Date(Date.parse(val.replace(/-/g, "/")));
            if(date)
            {
                if(current_date +30>=date)
                    return "<span class=\"glyphicon glyphicon-exclamation-sign red\"></span>即将到期";
            }
        }
        return "";
    }

    /**
     * 图形定位
     * @param objectId
     */
    function mapLocation(objectId){
        var url="/emapserver/map/map.action?action=location&params=";
        var params=new Object();
        params.layerAlias = '${layerAlias!}';
        params.where = "objectid ='"+ objectId+"'";
        url = url.concat(encodeURIComponent(JSON.stringify(params)));
        showMapWin(url);
    }

</script>
<div id="warp">
    <div id="grid" style="height:100%;width:100%">

    </div>
</div>
</@com.html>