<@com.html title="黑名单企业管理" import="jquery,bootstrap,highcharts,ext,base">

<script type="text/javascript">
    var store, gridPanel;
    Ext.require([
        'Ext.grid.*',
        'Ext.data.*',
        'Ext.util.*',
        'Ext.toolbar.Paging',
        'Ext.ModelManager',
        'Ext.tip.QuickTipManager',
        'Ext.form.field.Checkbox'
    ]);
    var rowEditing = Ext.create('Ext.grid.plugin.RowEditing', {
        clicksToMoveEditor: 1,
        autoCancel: false,
        pluginId:'rowEditing',
        saveBtnText: '保存',
        cancelBtnText: "取消"
    });

    rowEditing.on({
        scope: this,
        cancelEdit: function(e) {
            console.log("user clicked the cancel button");
        },
        edit:function(editor,changes){
            console.log("complete button");
            var myMask = new Ext.LoadMask(Ext.getBody(), {
                msg: '正在修改，请稍后...',
                removeMask: true
            });
            myMask.show();
            var params = changes.record.data;
            $.ajax({

                url: "/emapserver/warn/warn!update.action?type=${type!}",
                data: {
                    gddk: JSON.stringify(params)
                },
                success: function (response,_s) {
                    var result = JSON.parse(response);
                    myMask.hide();
                    if(result.success)
                    {
                        alert(result.msg);
                    }else
                    {
                        alert(result.msg);
                    }
                    store.load();
                },
                failure: function (response, opts) {

                    myMask.hide();
                    alert(response);
                }
            });
        }
    });

    var pageSize=parseInt((Ext.getBody().getViewSize().height-135)/20);
    var minHeight = Ext.getBody().getViewSize().height-135;

    Ext.onReady(function(){
        Ext.tip.QuickTipManager.init();

        store = new Ext.data.Store({
            pageSize:pageSize,
            model:'gddkModel',
            proxy:{
                type:'ajax',
                url:'warn!list.action?type='+'${type!}',
                reader:{
                    type:'json',
                    root:'items',
                    totalProperty:'totalCount'
                }
            },
            autoLoad:true
        });

        gridPanel = new Ext.grid.Panel({
            percentageWidths:100,
            percentageHeights:100,
            minHeight:minHeight,
            selModel:cbSelModel,
            multiSelect:false,
            store:store,
            stateful:true,
            columns:[
                {text:'id', dataIndex:'objectId', width:100,hidden:true},
                {text:'地块编号', dataIndex:'dkbh', width:100},
                {text:'项目名称', dataIndex:'xmmc', width:100},
                {text:'土地坐落', dataIndex:'tdzl', width:100},
                {text:'用途', dataIndex:'yt', width:100},
                {text:'分类代码', dataIndex:'fldm', width:100},
                {text:'开工时间', dataIndex:'kgsj', width:100,renderer:dateFormat},
                {text:'竣工时间', dataIndex:'jgsj', width:100,renderer:dateFormat},
                {text:'约定开工时间', dataIndex:'ydkgsj', width:100,renderer:dateFormat},
                {text:'约定竣工时间', dataIndex:'ydjgsj', width:100,renderer:dateFormat},
                {text:'应缴出让金', dataIndex:'sjcrj', width:100},
                {text:'已缴出让金', dataIndex:'yjcrj', width:100},
                {text:'出让金到期时间', dataIndex:'crjsj', width:100,renderer:dateFormat},
                {
                    text:'一期应缴出让金',
                    dataIndex:'yjcrj1',
                    width:100,
                    field:
                    {
                        xtype:'textfield',
                        vtype:'area'
                    }
                },
                {
                    text:'一期应缴时间',
                    dataIndex:'crjsj1',
                    width:100,
                    field:
                    {
                        xtype: 'datefield',
                        format: 'Y年m月d',
                        submitFormat:'Y-m-d'
                    }
                },
                {
                    text:'一期实际缴纳出让金',
                    dataIndex:'sjcrj1',
                    width:100,
                    field:
                    {
                        xtype:'textfield',
                        vtype:'area'
                    }
                },
                {
                    text:'一期实际缴纳时间',
                    dataIndex:'sjcrjsj1',
                    width:100,
                    field:
                    {
                        xtype: 'datefield',
                        format: 'Y年m月d',
                        submitFormat:'Y-m-d'
                    }
                },
                {
                    text:'二期应缴出让金',
                    dataIndex:'yjcrj2',
                    width:100,
                    field:
                    {
                        xtype:'textfield',
                        vtype:'area'
                    }
                },
                {
                    text:'二期应缴时间',
                    dataIndex:'crjsj2',
                    width:100,
                    field:
                    {
                        xtype: 'datefield',
                        format: 'Y年m月d',
                        submitFormat:'Y-m-d'
                    }
                },
                {
                    text:'二期实际缴纳出让金',
                    dataIndex:'sjcrj2',
                    width:100,
                    field:
                    {
                        xtype:'textfield',
                        vtype:'area'
                    }
                },
                {
                    text:'二期实际缴纳时间',
                    dataIndex:'sjcrjsj2',
                    width:100,
                    field:
                    {
                        xtype: 'datefield',
                        format: 'Y年m月d',
                        submitFormat:'Y-m-d'
                    }
                },
                {
                    text:'三期应缴出让金',
                    dataIndex:'yjcrj3',
                    width:100,
                    field:
                    {
                        xtype:'textfield',
                        vtype:'area'
                    }
                },
                {
                    text:'三期应缴时间',
                    dataIndex:'crjsj3',
                    width:100,
                    field:
                    {
                        xtype: 'datefield',
                        format: 'Y年m月d',
                        submitFormat:'Y-m-d'
                    }
                },
                {
                    text:'三期实际缴纳出让金',
                    dataIndex:'sjcrj3',
                    width:100,
                    field:
                    {
                        xtype:'textfield',
                        vtype:'area'
                    }
                },
                {
                    text:'三期实际缴纳时间',
                    dataIndex:'sjcrjsj3',
                    width:100,
                    field:
                    {
                        xtype: 'datefield',
                        format: 'Y年m月d',
                        submitFormat:'Y-m-d'
                    }
                }
            ],
            renderTo:'grid',
            viewConfig:{
                stripeRows:false,
                trackOver:false,
                id:'idleLandGrid'
            },
            bbar: Ext.create('Ext.PagingToolbar', {
                store: store,
                displayInfo: true,
                displayMsg: '显示第 {0}至{1}条/共 {2}记录',
                emptyMsg: "尚未检测到数据"
            }),
            tbar: Ext.create('Ext.toolbar.Toolbar', {
                items:[
//                    {
//                        text: '导出报表',
//                        xtype: 'button',
//                        iconCls: 'export',
//                        width: 75,
//                        listeners:{
//                            click:function(){
//                            }
//                        }
//                    },
                    '->',
                    {
                        xtype:'textfield',
                        name:'searchField',
                        hideLabel:true,
                        emptyText:'快速检索',
                        listeners:{
                            change:function () {
                                onSearch(gridPanel);
                            }
                        }
                    }

                ]
            }),
            plugins:[rowEditing]

        });

        Ext.create('Ext.tip.ToolTip', {
            target:gridPanel.getView().el,
            delegate: gridPanel.getView().itemSelector,
            trackMouse: true,
            html: '双击编辑'
        });

    });
    /**
     *  格式化时间显示样式
     * @param val
     */
    function dateFormat(val) {
        if (val) {
            if (navigator.userAgent.toLowerCase().indexOf("chrome") > -1)
                return Ext.util.Format.date(new Date(val), "Y年m月d日H:i:s");
            else
                return Ext.util.Format.date(new Date(Date.parse(val.replace(/-/g, "/"))), "Y年m月d日H:i:s");
        }
        else return "";
    }

</script>
<div id="warp">
    <div id="grid" style="height:100%;width:100%">

    </div>
</div>
</@com.html>