<@com.html title="土地闲置预警" import="jquery,bootstrap,highcharts,ext,base">
<script type="text/javascript">
    var store, gridPanel;
    Ext.require([
        'Ext.grid.*',
        'Ext.data.*',
        'Ext.util.*',
        'Ext.toolbar.Paging',
        'Ext.ModelManager',
        'Ext.tip.QuickTipManager',
        'Ext.form.field.Checkbox',
        'Ext.grid.*'
    ]);
//    var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {
//        clicksToEdit: 2
//    });

    var rowEditing = Ext.create('Ext.grid.plugin.RowEditing', {
        clicksToMoveEditor: 1,
        autoCancel: false,
        pluginId:'rowEditing',
        saveBtnText: '保存',
        cancelBtnText: "取消"
    });

    rowEditing.on({
        scope: this,
        cancelEdit: function(e) {
            console.log("user clicked the cancel button");
        },
        edit:function(editor,changes){
            console.log("complete button");
            var myMask = new Ext.LoadMask(Ext.getBody(), {
                msg: '正在修改，请稍后...',
                removeMask: true
            });
            myMask.show();
            var params = changes.record.data;
            params.sjkgsj = submitDateFormat(params.sjkgsj);
            $.ajax({

                url: "/emapserver/warn/warn!update.action?type=${type!}",
                data: {
                    gddk: JSON.stringify(params)
                },
                success: function (response,_s) {

                    var result = JSON.parse(response);
//                    changes.record.commit();
                    myMask.hide();
                    if(result.success)
                    {
                        store.load();
                        Ext.Msg.show({
                            title:'操作提示',
                            msg: result.msg,
                            buttons: Ext.Msg.YES,
                            icon: Ext.Msg.WARNING
                        });
                    }else
                    {
                        alert(result.msg);
                    }

                },
                failure: function (response, opts) {

                    myMask.hide();
                }
            });
            <#--Ext.Ajax.request({-->

                <#--url: "/emapserver/warn/warn!update.action?type=${type!}",-->
                <#--params: {-->
                    <#--gddk: JSON.stringify(params)-->
                <#--},-->
                <#--success: function (response) {-->

                    <#--var result = JSON.parse(response.responseText);-->
<#--//                    changes.record.commit();-->
                    <#--myMask.hide();-->
                    <#--if(result.success)-->
                    <#--{-->
                        <#--Ext.Msg.show({-->
                            <#--title:'操作提示',-->
                            <#--msg: result.msg,-->
                            <#--buttons: Ext.Msg.YES,-->
                            <#--icon: Ext.Msg.WARNING-->
                        <#--});-->
                    <#--}else-->
                    <#--{-->
                        <#--alert(result.msg);-->
                    <#--}-->

                <#--},-->
                <#--failure: function (response, opts) {-->

                    <#--myMask.hide();-->
                <#--}-->

            <#--});-->
        }
    });

    var pageSize=parseInt((Ext.getBody().getViewSize().height-135)/20);
    var minHeight = Ext.getBody().getViewSize().height-135;

    Ext.onReady(function(){

        Ext.tip.QuickTipManager.init();

        store = new Ext.data.Store({
            pageSize:pageSize,
            model:'gddkModel',
            proxy:{
                type:'ajax',
                url:'warn!list.action?type='+'${type!}',
                reader:{
                    type:'json',
                    root:'items',
                    totalProperty:'totalCount'
                }
            },
            autoLoad:true
        });

        gridPanel = new Ext.grid.Panel({
            percentageWidths:100,
            percentageHeights:100,
            minHeight:minHeight,
            selModel:cbSelModel,
            multiSelect:false,
            store:store,
            stateful:true,
            columns:[
                {text:'id', dataIndex:'objectId', width:100, hidden:true},
                {text:'图形定位', width:80, renderer:mapRenderer,sortable:false},
                {text:'预警', width:50, renderer:warnRenderer,sortable:false},
//                {text:'动工提醒', dataIndex:'ydkgsj', width:100, renderer:warnKG, sortable:false},
//                {text:'竣工提醒', dataIndex:'ydjgsj', width:100, renderer:warnJG,sortable:false},
                {text:'地块编号', dataIndex:'dkbh', width:100},
                {text:'项目名称', dataIndex:'xmmc', width:100},
                {text:'土地坐落', dataIndex:'tdzl', width:100},
                {text:'用途', dataIndex:'yt', width:100},
                {
                    text: '分类代码',
                    dataIndex: 'fldm',
                    width: 100
                },
                {text:'开工时间', dataIndex:'kgsj', width:100, renderer:dateFormat},
                {text:'竣工时间', dataIndex:'jgsj', width:100, renderer:dateFormat},
                {text:'约定开工时间', dataIndex:'ydkgsj', width:100, renderer:dateFormat},
                {text:'约定竣工时间', dataIndex:'ydjgsj', width:100, renderer:dateFormat},
                {
                    text: '实际开工时间',
                    dataIndex: 'sjkgsj',
                    width: 100,
                    renderer: dateFormat,
                    field: {
                        xtype: 'datefield',
                        format: 'Y年m月d',
                        submitFormat:'Y-m-d',
//                        minValue: '01/01/06',
//                        minText: 'Cannot have a start date before the company existed!',
                        maxValue: Ext.Date.format(new Date(), 'Y年m月d')
                    }
                },
                {
                    text:'实际竣工时间',
                    dataIndex:'sjjgsj',
                    width:100,
                    renderer:dateFormat,
                    field: {
                        xtype: 'datefield',
                        format: 'Y年m月d',
                        submitFormat:'Y-m-d',
//                        minValue: '01/01/06',
//                        minText: 'Cannot have a start date before the company existed!',
                        maxValue: Ext.Date.format(new Date(), 'Y年m月d')
                    }}
//                {text:'抵押金额', dataIndex:'dyje', width:100},
//                {text:'抵押到期时间', dataIndex:'dydqsj', width:100, renderer:dateFormat},
//                {text:'应缴出让金', dataIndex:'sjcrj', width:100},
//                {text:'已缴出让金', dataIndex:'yjcrj', width:100},
//                {text:'出让金到期时间', dataIndex:'crjsj', width:100, renderer:dateFormat}
            ],
            renderTo:'grid',
            viewConfig:{
                stripeRows:false,
                trackOver:false,
                id:'idleLandGrid'
            },
            bbar: Ext.create('Ext.PagingToolbar', {
                store: store,
                displayInfo: true,
                displayMsg: '显示第 {0}至{1}条/共 {2}记录',
                emptyMsg: "尚未检测到数据"
            }),
            tbar: Ext.create('Ext.toolbar.Toolbar', {
                items:[
//                    {
//                        text: '导出报表',
//                        xtype: 'button',
//                        iconCls: 'export',
//                        width: 75,
//                        listeners:{
//                            click:function(){
//                                cellEditing.startEdit(0,11);
//                            }
//                        }
//                    },
                    '->',
                    {
                        xtype:'textfield',
                        name:'searchField',
                        hideLabel:true,
                        emptyText:'快速检索',
                        listeners:{
                            change:function () {
                                onSearch(gridPanel);
                            }
                        }
                    }


                ]
            }),
            plugins: [rowEditing]
        });

    });
    /**
     *  格式化时间显示样式
     * @param val
     */
    function dateFormat(val) {
        if (val) {
            if (navigator.userAgent.toLowerCase().indexOf("chrome") > -1)
                return Ext.util.Format.date(new Date(val), "Y年m月d日");
            else
                return Ext.util.Format.date(new Date(Date.parse(val.replace(/-/g, "/"))), "Y年m月d日");
        }
        else return "";
    }


    /**
     *
     * 预警
     * */
    function warnRenderer(value, p, r){
        var record = r.data;
        var current_date = new Date();
        var ydkgsj = getDate(record.ydkgsj);
        var ydjgsj = getDate(record.ydjgsj);
        var kgsj = getDate(record.kgsj);
        var jgsj = getDate(record.jgsj);

        if (current_date + 30 > ydkgsj && kgsj == null)
            return "<div style='text-align:center;width:100%'><span class='glyphicon glyphicon-exclamation-sign' style='color: green' title='约定开工前一个月，开工时间未填写'></span></div>";
        else if (current_date > ydkgsj && current_date + 30 > ydjgsj && jgsj == null)
            return "<div style='text-align:center;width:100%'><span class='glyphicon glyphicon-exclamation-sign' style='color: blue' title='定开工时间到约定竣工前一个月时间段内，开工时间未填写'></span></div>";
        else if (current_date + 30 > ydjgsj && jgsj == null)
            return "<div style='text-align:center;width:100%'><span class='glyphicon glyphicon-exclamation-sign' style='color: #ffff00' title='约定竣工前一个月，竣工时间未填'></span></div>";
        else if (current_date > ydjgsj && jgsj == null)
            return "<div style='text-align:center;width:100%'><span class='glyphicon glyphicon-exclamation-sign' style='color: #ff0000' title='约定竣工后，竣工时间未填写'></span></div>";
        else
            return null;
    }

    function getDate(val){
        if(!val)return null;
        if (navigator.userAgent.toLowerCase().indexOf("chrome") > -1)
            return new Date(val)
        else
            return new Date(Date.parse(val.replace(/-/g, "/")));
    }

    /**
     *  开工预警
     * @param val
     */
    function warnKG(val) {
        if (val) {
            var date;
            var current_date=new Date();
            if (navigator.userAgent.toLowerCase().indexOf("chrome") > -1)
                date = new Date(val)
            else
                date = new Date(Date.parse(val.replace(/-/g, "/")));
            if(date)
            {
                if(current_date>date)
                return "<span class=\"glyphicon glyphicon-exclamation-sign red\"></span>超期";
                else
                {
                    if(date.getMonth()==current_date.getMonth())
                    return "<span class=\"glyphicon glyphicon-info-sign orange\"></span>月内开工";
                }
            }
        }
        return "";
    }
    /**
     * 竣工预警
     * @param val
     */
    function warnJG(val,p,r) {
        if (val) {
            var date;
            var current_date=new Date();
            if (navigator.userAgent.toLowerCase().indexOf("chrome") > -1)
                date = new Date(val)
            else
                date = new Date(Date.parse(val.replace(/-/g, "/")));
            if(date)
            {
                if(current_date>date)
                    return "<span class=\"glyphicon glyphicon-exclamation-sign red\"></span>超期";
                else
                {
                    if(date.getMonth()==current_date.getMonth())
                        return "<span class=\"glyphicon glyphicon-info-sign orange\"></span>月内竣工";
                }
            }
        }
        return "";
    }
    /**
     * 图形定位
     * @param objectId
     */
    function mapLocation(objectId){
        var url="/emapserver/map/map.action?action=location&params=";
        var params=new Object();
        params.layerAlias = '${layerAlias!}';
        params.where = "objectid ='"+ objectId+"'";
        url = url.concat(encodeURIComponent(JSON.stringify(params)));
        showMapWin(url);
    }

</script>
<div id="warp">
    <div id="grid" style="height:100%;width:100%">

    </div>
</div>
</@com.html>