<@com.html title="南通滨海园区土地动态监管系统" import="jquery,bootstrap,highcharts,ext,base">
<style type="text/css">

    body {
        background-color: #f4f5f6;
        font-family: "微软雅黑";
    }

    #warp {
        margin: 0 auto;
        width: 100%;
        padding: 20px;
    }

    #header h3 {
        color: #17b6e3;
        font-size: 26px;
    }

    .chartDiv {
        width: 30%;
        height: 600px;
        float: left;
        background: transparent
    }

</style>
<script type="text/javascript">


var store, gridPanel, sum = '${summary}';
$(function () {

    Highcharts.setOptions(Highcharts.theme);

    $('#chartDiv1').highcharts({
        chart:{
            plotBackgroundColor:null,
            plotBorderWidth:null,
            plotShadow:false
        },
        title:{
            text:'用户统计',
            style:{

                fontFamily:'microsoft yahei',
                fontSize:'16px'
            },
            x:-20
        },
        tooltip:{
            formatter:function () {
                return this.point.name + '<br/><b>' + Math.round(this.percentage) + '</b>%';
            }
        },
        legend:{
            enabled:true,
            layout:'horizontal',
            align:'center',
            verticalAlign:'bottom'
        },
        plotOptions:{
            pie:{
                allowPointSelect:true,
                cursor:'pointer',
                dataLabels:{
                    enabled:false,
                    distance:-35,
                    color:'#000000',
                    connectorColor:'#000000',
                    formatter:function () {
                        return Math.round(this.percentage) + ' %';    //'<b>' + this.point.name + '</b>: ' +
                    }
                }
            }
        },
        credits:{
            enabled:false
        },
        exporting:{
            enabled:false
        },
        series:[
            {
                type:'pie',
                name:'操作数占比',
                data:[
                    <#list summary as sum>
                        ['${sum['name']}',${sum['count']}]<#if sum_has_next>,</#if>
                    </#list>
                ],
                showInLegend:true
            }
        ]
    });

    $('#chartDiv2').highcharts({
        chart:{
            zoomType:'x',
            spacingRight:20
        },
        title:{
            text:'监控数统计'
        },
        xAxis:{
            type:'datetime',
            maxZoom:14 * 24 * 3600000, // fourteen days
            title:{
                text:'日期'
            }
        },
        yAxis:{
            title:{
                text:'记录数'
            }
        },
        tooltip:{
            xDateFormat:'%Y-%m-%d',
            shared:true
        },
        credits:{
            enabled:false
        },
        exporting:{
            enabled:false
        },
        legend:{
            enabled:false
        },
        plotOptions:{
            area:{
                fillColor:{
                    linearGradient:{ x1:0, y1:0, x2:0, y2:1},
                    stops:[
                        [0, Highcharts.getOptions().colors[0]],
                        [1, Highcharts.Color(Highcharts.getOptions().colors[0]).setOpacity(0).get('rgba')]
                    ]
                },
                lineWidth:1,
                marker:{
                    enabled:false
                },
                shadow:false,
                states:{
                    hover:{
                        lineWidth:1
                    }
                },
                threshold:null
            }
        },
        series:[
            {
                type:'area',
                name:'记录数',
                pointInterval:24 * 3600 * 1000,
                pointStart:Date.UTC(${startDate["year"]}, Number(${startDate["month"]}) - 1, ${startDate["day"]}),
                data:[
                    <#list stock as item>
                    [Date.UTC(${item["year"]}, Number(${item["month"]}) - 1, ${item["day"]}),${item["count"]!}]<#if item_has_next>,</#if>
                    </#list>

                ]
            }
        ]
    });


});

Ext.require([
    'Ext.grid.*',
    'Ext.data.*',
    'Ext.util.*',
    'Ext.form.field.Checkbox',
    'Ext.tip.QuickTipManager'
]);

Ext.onReady(function () {
    Ext.QuickTips.init();
    store = new Ext.data.Store({
        pageSize:20,
        model:'monitorModel',
        proxy:{
            type:'ajax',
            url:'monitor!list.action',
            reader:{
                type:'json',
                root:'items',
                totalProperty:'totalCount'
            }
        },
        autoLoad:true
    });

    gridPanel = new Ext.grid.Panel({
        title:"监控信息列表",
        height:560,
        percentageWidths:100,
        store:store,
        stateful:true,
        multiSelect:false,
        columns:[
            {text:'id', dataIndex:'id', width:200},
            {text:'用户名', dataIndex:'userName', width:200},
            {text:'所属部门', dataIndex:'organName', width:200},
//            {text:'角色名', dataIndex:'roleName', width:200},
            {text:'操作时间', dataIndex:'operaTime', width:180, renderer:dateFormat},
            {text:'操作类型', dataIndex:'operaType', width:150},
            {text:'操作详细', dataIndex:'operaDetail', width:250},
            {text:'备注', dataIndex:'bz', width:100}

        ],
        renderTo:'MONITORInfo',
        viewConfig:{
            stripeRows:true

        },
        dockedItems:[
            {
                xtype:'toolbar',
                items:[ '快速检索',
                    {
                        xtype:'textfield',
                        name:'searchField',
                        hideLabel:true,
                        width:130,
                        height:24,
                        align:'center',
                        listeners:{
                            change:function () {
                                onSearch(gridPanel);
                            }
                        }
                    },
                    {
                        xtype:'button',
                        text:'条件检索',
                        handler:function (e) {
                            onAddCondition(e);
                        }
                    }
                ]
            },
            {
                xtype:'pagingtoolbar',
                pageSize:20,
                height:30,
                store:store,
                dock:'bottom',
                displayInfo:true,
                displayMsg:'{0}-{1}共{2}条',
                emptyMsg:"尚未检测到数据"
            }
        ]

    });

});

/**
 *  格式化时间显示样式
 * @param val
 */
function dateFormat(val) {

    if (val) {
        if (navigator.userAgent.toLowerCase().indexOf("chrome") > -1)
            return Ext.util.Format.date(new Date(val), "Y年m月d日H:i:s");
        else
            return Ext.util.Format.date(new Date(Date.parse(val.replace(/-/g, "/"))), "Y年m月d日H:i:s");
    }
    else return "";
}

var selectedStore = Ext.create('gtis.store.SelectedFStore', {});

var leftGrid = Ext.create('gtis.panel.LeftDragPanel', {store:new Ext.data.SimpleStore({
    fields:['name', 'field', 'title', 'condition', 'value'],
    data:[['id','id','ID'],['userName','userName','用户名'],['roleName','roleName','角色名'],['operaType','operaType','操作类型'],['operaDetail','operaDetail','操作细节'],['operaTime','operaTime','操作时间']]

})});

var rightDrop = Ext.create('gtis.panel.RightDropPanel', {store:selectedStore});

</script>

<div id="warp">
    <div id="header" style="text-align: center;"><h3>土地动态监管系统监控</h3></div>
    <div style="height: 20px;margin-right: 10px;float:right;"><a href="/emapserver/index.action">回到主页</a></div>


    <div style="width: 100%;height: 100%;">
        <div>
            <ul class="nav nav-tabs">
                <li class="active"><a href="#MONITORInfo" data-toggle="tab">实时监控</a></li>
                <li><a href="#CHARTInfo" data-toggle="tab">图表统计</a></li>
                <li><a href="#REPORTInfo" data-toggle="tab">报表统计</a></li>
            </ul>
        </div>
        <div class="tab-content">
            <div id="MONITORInfo" class="tab-pane fade in active">

            </div>
            <div id="CHARTInfo" class="tab-pane fade">
                <div id="chartDiv1" class="chartDiv">

                </div>
                <div id="chartDiv2" class="chartDiv" style="width:67%;margin-left: 10px;">
                </div>
            </div>
            <div id="REPORTInfo" class="tab-pane fade">
                <iframe id="iframe" name="iframe" src="/report/report.jsp?f=monitor.raq" frameborder="0" width="100%" height="100%" style="min-height: 800px;">
                </iframe>
            </div>
        </div>
    </div>
</div>

</@com.html>