<@com.html title="南通滨海园区土地动态监管系统" import="jquery,bootstrap,highcharts,ext,base">
<script type="text/javascript">
    var store, gridPanel;
    Ext.require([
        'Ext.grid.*',
        'Ext.data.*',
        'Ext.util.*',
        'Ext.toolbar.Paging',
        'Ext.ModelManager',
        'Ext.tip.QuickTipManager',
        'Ext.form.field.Checkbox'
    ]);
    var pageSize=parseInt((Ext.getBody().getViewSize().height-135)/20);
    Ext.onReady(function(){
        Ext.tip.QuickTipManager.init();

        store = new Ext.data.Store({
            pageSize:pageSize,
            model:'xfqkbModel',
            proxy:{
                type:'ajax',
                url:'ledger!list.action?type='+'${type!}',
                reader:{
                    type:'json',
                    root:'items',
                    totalProperty:'totalCount'
                }
            },
            autoLoad:true
        });

        gridPanel = new Ext.grid.Panel({
            percentageWidths:100,
            percentageHeights:100,
            minHeight:300,
            selModel:cbSelModel,
            multiSelect:false,
            store:store,
            stateful:true,
            columns:[
                {text:'id', dataIndex:'projectId', width:100,hidden:true},
//                {text:'图形定位', width:50, renderer:mapRenderer,sortable:false},
                {text:'编号', dataIndex:'xfbh', width:100},
                {text:'所在区县', dataIndex:'szqx', width:100},
                {text:'所在乡镇', dataIndex:'szxz', width:100},
                {text:'信访人姓名', dataIndex:'xfrxm', width:100},
                {text:'信访人联系电话', dataIndex:'xfrlxdh', width:100},
                {text:'信访人联系地址', dataIndex:'xfrlxdz', width:100},
                {text:'信访人涉地越级上访部门', dataIndex:'xfbm', width:100},
                {text:'上访时间', dataIndex:'sfsj', width:100,renderer:dateFormat},
                {text:'信访问题', dataIndex:'xfwt', width:100},
                {text:'信访人诉求', dataIndex:'xfrsq', width:100},
                {text:'信访人反映的类型', dataIndex:'fylx', width:100},
                {text:'调查后认定的类型', dataIndex:'dcrdlx', width:100},
                {text:'反映情况是否属实', dataIndex:'sfss', width:100},
                {text:'信访问题调查处理情况', dataIndex:'dcclqk', width:100},
                {text:'违法用地单位', dataIndex:'wfyddw', width:100},
                {text:'违法用地位置', dataIndex:'wfydwz', width:100},
                {text:'违法用地面积', dataIndex:'wfydmj', width:100},
                {text:'备注', dataIndex:'bz', width:100}
            ],
            renderTo:'grid',
            viewConfig:{
                stripeRows:true,
                trackOver:false,
                id:'xfqkbGrid'
            },
            bbar: Ext.create('Ext.PagingToolbar', {
                store: store,
                displayInfo: true,
                displayMsg: '显示第 {0}至{1}条/共 {2}记录',
                emptyMsg: "尚未检测到数据"
            }),
            tbar: Ext.create('Ext.toolbar.Toolbar', {
                items:[
//                    {
//                        text: '导出报表',
//                        xtype: 'button',
//                        iconCls: 'export',
//                        listeners:{
//                            click:function(){
//                                exportData();
//                            }
//                        }
//                    },
                    '->',
                    {
                        xtype:'textfield',
                        name:'searchField',
                        hideLabel:true,
                        emptyText:'快速检索',
//                        fieldLabel:'快速检索',
//                        labelWidth:60,
//                        labelStyle:"font-weight: normal;",
                        listeners:{
                            change:function () {
                                onSearch(gridPanel);
                            }
                        }

                    }

                ]
            })

        });


    });

    /**
     *  格式化时间显示样式
     * @param val
     */
    function dateFormat(val) {

        if (val) {
            if (navigator.userAgent.toLowerCase().indexOf("chrome") > -1)
                return Ext.util.Format.date(new Date(val), "Y年m月d日H:i:s");
            else
                return Ext.util.Format.date(new Date(Date.parse(val.replace(/-/g, "/"))), "Y年m月d日H:i:s");
        }
        else return "";
    }

    /**
     * 图形定位
     * @param objectId
     */
    function mapLocation(projectId){
        var url="/emapserver/map/map.action?action=location&params=";
        var params=new Object();
        params.layerAlias = '${layerAlias!}';
        params.where = "projectid ='"+ projectId+"'";
        url = url.concat(encodeURIComponent(JSON.stringify(params)));
        showMapWin(url);
    }
    /**
     * 导出报表
     */
    function exportData(){

        var rows = gridPanel.getSelectionModel().getSelection();
        if(rows==null||rows.length==0){
            Ext.Msg.alert('提示', "请选择要操作的数据！");
            return;
        }
        var conditions = new Array();
        var ids=new Array();
        for (var i = 0; i < rows.length; i++) {
            ids.push("'"+rows[i].get('projectId')+"'");
        }
        var obj=new Object();
        obj.field = "PROJECTID";
        obj.condition = "IN";
        obj.value = "("+ids.join(',')+")";
        conditions.push(obj);

        Ext.Ajax.request({
            url:"ledger!export.action?type=${type!}",
            params:{condition:JSON.stringify(conditions),fileName:"xfqkb.xls"},
            method:'POST',
            success: function(response){
//                var result =JSON.parse(response.responseText);
//                Ext.Msg.alert("",result.msg);
//                setTimeout(function () {
//                    Ext.MessageBox.hide();
//                    store.load();
//                }, 1500);

            }
        });

    }

</script>
<div id="warp">
    <div id="grid" style="height:100%;width:100%">

    </div>

</div>

</@com.html>