<@com.html title="南通滨海园区土地动态监管系统" import="jquery,bootstrap,highcharts,ext,base">
<style type="text/css">

</style>
<script type="text/javascript">
    var store, gridPanel;
    Ext.require([
        'Ext.grid.*',
        'Ext.data.*',
        'Ext.util.*',
        'Ext.toolbar.Paging',
        'Ext.ModelManager',
        'Ext.tip.QuickTipManager',
        'Ext.form.field.Checkbox'
    ]);
    var pageSize=parseInt((Ext.getBody().getViewSize().height-135)/20);
    Ext.onReady(function(){
        Ext.tip.QuickTipManager.init();

        store = new Ext.data.Store({
            pageSize:pageSize,
            model:'jctbModel',
            proxy:{
                type:'ajax',
                url:'ledger!list.action?type='+'${type!}',
                reader:{
                    type:'json',
                    root:'items',
                    totalProperty:'totalCount'
                }
            },
            autoLoad:true
        });

        gridPanel = new Ext.grid.Panel({
            percentageWidths:100,
            percentageHeights:100,
            minHeight:300,
            selModel:cbSelModel,
            multiSelect:true,
            store:store,
            stateful:true,
            columns:[
                {text:'id', dataIndex:'objectId', width:100,hidden:true},
                {text:'图形定位', width:50, renderer:mapRenderer,sortable:false},
                {text:'行政区代码', dataIndex:'xzqdm', width:100},
                {text:'行政区名称', dataIndex:'xzqmc', width:100},
                {text:'监测编号', dataIndex:'jcbh', width:100},
                {text:'图斑类型', dataIndex:'tblx', width:100},
                {text:'监测面积', dataIndex:'jcmj', width:100},
                {text:'变更范围', dataIndex:'bgfw', width:100},
                {text:'土地利用', dataIndex:'tdly', width:100},
                {text:'地类用途', dataIndex:'dlyt', width:100}
            ],
            renderTo:'grid',
            viewConfig:{
                stripeRows:true,
                trackOver:false,
                id:'jctbGrid'
            },
            bbar: Ext.create('Ext.PagingToolbar', {
                store: store,
                displayInfo: true,
                displayMsg: '显示第 {0}至{1}条/共 {2}记录',
                emptyMsg: "尚未检测到数据"
            }),
            tbar: Ext.create('Ext.toolbar.Toolbar', {
                items:[
                    {
                        xtype: 'combobox',
                        id:'xzqCombox',
                        typeAhead: true,
                        triggerAction: 'all',
                        selectOnTab: true,
                        emptyText:'选择区域',
                        store: [
                            ['3206','全部'],
                            ['320683','如东'],
                            ['320683','通州']
                        ],
                        lazyRender: true,
                        listClass: 'x-combo-list-small'
                    },'-',
                    {
                        text: '导出报表',
                        xtype: 'button',
                        iconCls: 'excel',
                        listeners:{
                            click:function(){

                                var conditions=new Array();
                                if (Ext.getCmp('xzqCombox').lastSelection.length > 0) {
                                    var xzqdm=Ext.getCmp('xzqCombox').lastSelection[0].data.field1;
                                    var condition={};
                                    condition.field = 'XZQDM';
                                    condition.condition = 'like';
                                    condition.value = xzqdm;
                                    conditions.push(condition);
                                    exportExcel('${type!}', JSON.stringify(conditions),'jctb.xls');
                                } else
                                    alert("请先选择导出范围");

                            }
                        }
                    },'-',
                    {
                        text: '导出图形',
                        xtype: 'button',
                        iconCls: 'zip',
                        listeners:{
                            click:function(){

                                var conditions=new Array();
                                if (Ext.getCmp('xzqCombox').lastSelection.length > 0) {
                                    var xzqdm=Ext.getCmp('xzqCombox').lastSelection[0].data.field1;
                                    var condition={};
                                    condition.field = 'XZQDM';
                                    condition.condition = 'like';
                                    condition.value = xzqdm;
                                    conditions.push(condition);
                                    exportShp('${type!}', JSON.stringify(conditions));
                                } else
                                    alert("请先选择导出范围");
                            }
                        }
                    },'->',
                    {
                        xtype:'textfield',
                        name:'searchField',
                        hideLabel:true,
                        emptyText:'快速检索',
                        listeners:{
                            change:function () {
                                onSearch(gridPanel);
                            }
                        }
                    }

                ]
            })

        });

    });
    /**
     *  格式化时间显示样式
     * @param val
     */
    function dateFormat(val) {

        if (val) {
            if (navigator.userAgent.toLowerCase().indexOf("chrome") > -1)
                return Ext.util.Format.date(new Date(val), "Y年m月d日H:i:s");
            else
                return Ext.util.Format.date(new Date(Date.parse(val.replace(/-/g, "/"))), "Y年m月d日H:i:s");
        }
        else return "";
    }

    /**
     * 图形定位
     * @param objectId
     */
    function mapLocation(objectId){
        var url="/emapserver/map/map.action?action=location&params=";
        var params=new Object();
        params.layerAlias = '${layerAlias!}';
        params.where = "objectid ='"+ objectId+"'";
        url = url.concat(encodeURIComponent(JSON.stringify(params)));
        showMapWin(url);
    }

</script>
<div id="warp">
    <div id="grid" style="height:100%;width:100%">

    </div>
</div>
</@com.html>