/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.web.warn;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gtis.common.Page;
import com.gtis.emapserver.core.web.BaseAction;
import com.gtis.emapserver.entity.DJDK;
import com.gtis.emapserver.entity.GDDK;
import com.gtis.emapserver.service.GISManager;
import com.gtis.emapserver.service.WarnService;
import com.gtis.emapserver.utils.EnvContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarnAction
extends BaseAction {
    @Autowired
    private WarnService warnService;
    @Autowired
    private EnvContext envContext;
    @Autowired
    private GISManager gisManager;
    private static final String TYPE_IDLELAND = "idleLand";
    private static final String TYPE_ILLEGALENTERPRISE = "illegalEnterprise";
    private static final String TYPE_MORTGAGEEXPIRE = "mortgageExpire";
    protected int start;
    protected int limit = 20;
    private Map condition;
    private GDDK gddk;
    private DJDK djdk;
    private String type;

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String execute() {
        return this.type;
    }

    public Page<GDDK> list() throws IOException {
        try {
            this.sendJson((Object)this.warnService.getPages(this.start, this.limit, this.condition, this.type));
        }
        catch (IOException e) {
            this.logger.error(e.getLocalizedMessage());
            this.sendJson((Object)new Page());
        }
        return null;
    }

    public String count() throws IOException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        try {
            int count = this.warnService.count(this.type, this.condition);
            result.put(this.type, count);
            this.sendJson(result);
        }
        catch (IOException e) {
            this.logger.error(e.getLocalizedMessage());
            result.put(this.type, 0);
            this.sendJson(result);
        }
        return null;
    }

    public void update() throws IOException {
        boolean success = false;
        try {
            success = !this.isNull((Object)this.gddk) ? this.warnService.update2((Object)this.gddk, this.type) : this.warnService.update2((Object)this.djdk, this.type);
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
        }
        if (success) {
            this.sendOk("\u66f4\u65b0\u6210\u529f\uff01");
        } else {
            this.sendError("\u66f4\u65b0\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u540e\u53f0\u6253\u5370\u65e5\u5fd7!");
        }
    }

    public void setCondition(String value) {
        this.condition = new HashMap();
        if (StringUtils.isBlank((String)value)) {
            return;
        }
        ArrayList<String> conditions = new ArrayList<String>();
        JSONArray conJson = JSON.parseArray((String)value);
        for (Object obj : conJson) {
            conditions.add(this.seriCondition((JSONObject)obj));
        }
        this.condition.put("condition", conditions);
    }

    public Map getCondition() {
        return this.condition;
    }

    private String seriCondition(JSONObject item) {
        String condition = item.getString("field").concat(" ").concat(item.getString("condition").concat(" "));
        condition = item.getString("condition").equalsIgnoreCase("like") ? condition.concat("'%").concat(item.getString("value").concat("%'")) : condition.concat(item.getString("value"));
        return condition;
    }

    public Object getLayerAlias() {
        return this.envContext.getEnv("map.gddk.layer");
    }

    public GDDK getGddk() {
        return this.gddk;
    }

    public void setGddk(String gddk) {
        this.gddk = (GDDK)JSON.parseObject((String)gddk, GDDK.class);
    }

    public DJDK getDjdk() {
        return this.djdk;
    }

    public void setDjdk(String djdk) {
        this.djdk = (DJDK)JSON.parseObject((String)djdk, DJDK.class);
    }
}

