/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.web.map;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.gtis.emapserver.core.web.BaseAction;
import com.gtis.emapserver.entity.Function;
import com.gtis.emapserver.service.GISManager;
import com.gtis.emapserver.service.MapService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class EditAction
extends BaseAction {
    @Autowired
    private GISManager gisManager;
    @Autowired
    private MapService mapService;
    private String[] serviceIds;
    private String layerName;
    private Map columns;
    private String dataSource;
    private String id;

    public String execute() throws Exception {
        boolean success = false;
        try {
            success = this.gisManager.getGISService().insert(this.layerName, this.columns, this.dataSource);
        }
        catch (Exception e) {
            this.logger.error("\u7f16\u8f91\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.logger.error("\u5f02\u5e38\u8be6\u7ec6\u4fe1\u606f:", (Object)e.toString());
            e.printStackTrace();
            this.sendError("\u7f16\u8f91\u5f02\u5e38\u3010" + e.getLocalizedMessage() + "\u3011");
            return null;
        }
        if (success) {
            this.sendOk("\u7f16\u8f91\u6210\u529f\uff01");
        } else {
            this.sendError("\u7f16\u8f91\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u540e\u53f0\u6253\u5370\u65e5\u5fd7!");
        }
        return null;
    }

    public void update() throws IOException {
        boolean success = false;
        try {
            success = this.gisManager.getGISService().update(this.layerName, this.id, this.columns, this.dataSource);
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendError("\u66f4\u65b0\u5f02\u5e38\u3010" + e.getLocalizedMessage() + "\u3011");
            return;
        }
        if (success) {
            this.sendOk("\u66f4\u65b0\u6210\u529f\uff01");
        } else {
            this.sendError("\u66f4\u65b0\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u540e\u53f0\u6253\u5370\u65e5\u5fd7!");
        }
    }

    public void delete() throws IOException {
        boolean success = false;
        try {
            success = this.gisManager.getGISService().delete(this.layerName, this.id, this.dataSource);
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendError("\u5220\u9664\u51fa\u73b0\u5f02\u5e38\u3010{" + e.getLocalizedMessage() + "}\u3011");
            return;
        }
        if (success) {
            this.sendOk("\u5220\u9664\u6210\u529f\uff01");
        } else {
            this.sendError("\u5220\u9664\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u540e\u53f0\u6253\u5370\u65e5\u5fd7!");
        }
    }

    public void config() throws IOException {
        ArrayList<Object> functions = new ArrayList<Object>();
        for (String serviceId : this.serviceIds) {
            Function function = this.mapService.getFunctionByType(new Function(serviceId, Function.Type.EDIT.getId()));
            if (function == null) continue;
            JSONArray array = function.getConfigLayers();
            for (int i = 0; i < array.size(); ++i) {
                functions.add(array.get(i));
            }
        }
        this.sendJson(functions);
    }

    public void setServiceIds(String value) {
        this.serviceIds = value.split(";");
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    public void setColumns(String value) {
        try {
            this.columns = (Map)JSON.parseObject((String)value, Map.class);
        }
        catch (Exception e) {
            this.logger.error("\u89e3\u6790\u7f16\u8f91\u5217\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
        }
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public void setId(String id) {
        this.id = id;
    }
}

