/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.web;

import com.alibaba.fastjson.JSON;
import com.gtis.emapserver.core.web.BaseAction;
import com.gtis.emapserver.service.WorkflowService;
import com.gtis.emapserver.utils.EnvContext;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

public class WorkflowAction
extends BaseAction {
    private static final String WF_TYPE_XFDJ = "xfdj";
    private static final String WF_TYPE_XXGK = "xxgk";
    private static final String WF_TYPE_ZFXC = "zfxc";
    private static final String WF_TYPE_BGDC = "bgdc";
    private static final String WF_TYPE_YDXC = "ydxc";
    private static final String WF_KEY_PROID = "proid";
    @Autowired
    private EnvContext envContext;
    @Autowired
    private WorkflowService workflowService;
    private String type;
    private String proid;
    private String layerName;
    private Map columns;
    private String dataSource;
    private String pk;
    private String eventName;
    private int state;

    public void location() throws IOException {
        try {
            HttpServletResponse response = ServletActionContext.getResponse();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("layerAlias", this.getLayerAlias());
            params.put("where", "proid = '" + this.proid + "'");
            response.sendRedirect("/emapserver/map/map.action?action=location&params=".concat(JSON.toJSONString(params)));
        }
        catch (IOException e) {
            this.sendError(e.getLocalizedMessage());
        }
    }

    public void editPlot() throws IOException {
        boolean success = false;
        try {
            success = this.workflowService.editPlot(this.proid, this.type, this.pk, this.layerName, this.dataSource, this.columns);
        }
        catch (Exception e) {
            this.logger.error(this.getMessage("edit.error", new Object[]{e.getLocalizedMessage()}));
            this.sendError(this.getMessage("edit.error", new Object[]{e.getLocalizedMessage()}));
            return;
        }
        if (success) {
            this.sendOk(this.getMessage("edit.success", new Object[0]));
        } else {
            this.sendError(this.getMessage("edit.error.log", new Object[0]));
        }
    }

    public void changeState() throws IOException {
        boolean success = false;
        try {
            success = this.workflowService.changeState(this.proid, this.state, this.envContext.getEnv("state.field.name").toString(), this.layerName, this.dataSource);
        }
        catch (Exception e) {
            this.logger.error(this.getMessage("state.change.error", new Object[]{e.getLocalizedMessage()}));
            this.sendError(this.getMessage("state.change.error", new Object[]{e.getLocalizedMessage()}));
            return;
        }
        if (success) {
            this.sendOk(this.getMessage("state.change.success", new Object[0]));
        } else {
            this.sendError(this.getMessage("state.change.error", new Object[0]));
        }
    }

    public Object getLayerAlias() {
        if (this.type.equals(WF_TYPE_XFDJ)) {
            return this.envContext.getEnv("map.xfdk.layer");
        }
        if (this.type.equals(WF_TYPE_XXGK)) {
            return this.envContext.getEnv("map.xxgk.layer");
        }
        if (this.type.equals(WF_TYPE_BGDC)) {
            return this.envContext.getEnv("map.jctb.layer");
        }
        if (this.type.equals(WF_TYPE_YDXC)) {
            return this.envContext.getEnv("map.ydxc.layer");
        }
        if (this.type.equals(WF_TYPE_ZFXC)) {
            return this.envContext.getEnv("map.wfyd.layer");
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLayerName() {
        return this.layerName;
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public String getPk() {
        return this.pk;
    }

    public void setPk(String pk) {
        this.pk = pk;
    }

    public String getProid() {
        return this.proid;
    }

    public void setProid(String proid) {
        this.proid = proid;
    }

    public void setColumns(String value) {
        try {
            this.columns = (Map)JSON.parseObject((String)value, Map.class);
        }
        catch (Exception e) {
            this.logger.error(this.getMessage("edit.columns.parse.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }
}

