/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.web;

import com.alibaba.fastjson.JSON;
import com.gtis.common.util.Md5Util;
import com.gtis.emapserver.core.web.BaseAction;
import com.gtis.emapserver.entity.Permission;
import com.gtis.emapserver.service.PermissionService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionAction
extends BaseAction {
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private SysUserService userService;
    private String operation;
    private String resourcekey;
    private String roleId;
    private String userId;
    private String orginalPwd;
    private String newPwd;
    private List<Permission> ydxcPerms;
    private List<Permission> zfxcPerms;
    private List<Permission> bgdcPerms;
    private List<Permission> ydxcRevoke;
    private List<Permission> zfxcRevoke;
    private List<Permission> bgdcRevoke;

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getResourcekey() {
        return this.resourcekey;
    }

    public void setResourcekey(String resourcekey) {
        this.resourcekey = resourcekey;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public List<Permission> getYdxcPerms() {
        return this.ydxcPerms;
    }

    public void setYdxcPerms(String perm) {
        if (StringUtils.isBlank((String)perm)) {
            return;
        }
        try {
            this.ydxcPerms = JSON.parseArray((String)perm, Permission.class);
        }
        catch (Exception e) {
            this.logger.error("\u89e3\u6790\u6388\u6743JSON\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
        }
    }

    public List<Permission> getYdxcRevoke() {
        return this.ydxcRevoke;
    }

    public void setYdxcRevoke(String perm) {
        if (StringUtils.isBlank((String)perm)) {
            return;
        }
        try {
            this.ydxcRevoke = JSON.parseArray((String)perm, Permission.class);
        }
        catch (Exception e) {
            this.logger.error("\u89e3\u6790\u6388\u6743JSON\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
        }
    }

    public List<Permission> getZfxcRevoke() {
        return this.zfxcRevoke;
    }

    public void setZfxcRevoke(String perm) {
        if (StringUtils.isBlank((String)perm)) {
            return;
        }
        try {
            this.zfxcRevoke = JSON.parseArray((String)perm, Permission.class);
        }
        catch (Exception e) {
            this.logger.error("\u89e3\u6790\u6388\u6743JSON\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
        }
    }

    public List<Permission> getZfxcPerms() {
        return this.zfxcPerms;
    }

    public void setZfxcPerms(String perm) {
        if (StringUtils.isBlank((String)perm)) {
            return;
        }
        try {
            this.zfxcPerms = JSON.parseArray((String)perm, Permission.class);
        }
        catch (Exception e) {
            this.logger.error("\u89e3\u6790\u6388\u6743JSON\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
        }
    }

    public List<Permission> getBgdcPerms() {
        return this.bgdcPerms;
    }

    public void setBgdcPerms(String perm) {
        if (StringUtils.isBlank((String)perm)) {
            return;
        }
        try {
            this.bgdcPerms = JSON.parseArray((String)perm, Permission.class);
        }
        catch (Exception e) {
            this.logger.error("\u89e3\u6790\u6388\u6743JSON\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
        }
    }

    public List<Permission> getBgdcRevoke() {
        return this.bgdcRevoke;
    }

    public void setBgdcRevoke(String perm) {
        if (StringUtils.isBlank((String)perm)) {
            return;
        }
        try {
            this.bgdcRevoke = JSON.parseArray((String)perm, Permission.class);
        }
        catch (Exception e) {
            this.logger.error("\u89e3\u6790\u6388\u6743JSON\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
        }
    }

    public String hasPermission() throws Exception {
        if (StringUtils.isBlank((String)this.resourcekey) || StringUtils.isBlank((String)this.operation)) {
            this.sendError("\u53c2\u6570\u5f02\u5e38");
        } else {
            this.sendJson((Object)this.permissionService.hasPermission(this.resourcekey, this.operation));
        }
        return null;
    }

    public boolean hasPermissionByRole() throws Exception {
        if (StringUtils.isBlank((String)this.resourcekey) || StringUtils.isBlank((String)this.operation) || StringUtils.isBlank((String)this.roleId)) {
            this.sendError("\u53c2\u6570\u5f02\u5e38");
        } else {
            this.sendJson((Object)this.permissionService.hasPermission(this.resourcekey, this.roleId, this.operation));
        }
        return false;
    }

    public String getPermissions() throws Exception {
        if (StringUtils.isBlank((String)this.resourcekey) || StringUtils.isBlank((String)this.roleId)) {
            this.sendError("\u53c2\u6570\u5f02\u5e38");
        } else {
            this.sendJson((Object)this.permissionService.getPermissions(this.resourcekey, this.roleId));
        }
        return null;
    }

    public String getModels() throws Exception {
        if (StringUtils.isBlank((String)this.roleId)) {
            this.sendError("\u53c2\u6570\u5f02\u5e38");
        } else {
            this.sendJson((Object)this.permissionService.getPermsModels(this.roleId));
        }
        return null;
    }

    public String userPerms() {
        try {
            UserInfo userInfo = SessionUtil.getCurrentUser();
            String roleIds = userInfo.getRoleIds();
            StringBuilder roleName = new StringBuilder();
            ArrayList permissionList = new ArrayList();
            ArrayList<String> perms = new ArrayList<String>();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("userId", userInfo.getId());
            map.put("userName", userInfo.getUsername());
            map.put("roleIds", userInfo.getRoleIds());
            map.put("isAdmin", userInfo.isAdmin());
            map.put("regionCode", this.userService.getRegionCodeByUserId(userInfo.getId()));
            String userId = SessionUtil.getCurrentUserId();
            List roleVos = this.userService.getRoleListByUser(userId);
            for (int i = 0; i < roleVos.size(); ++i) {
                PfRoleVo roleVo = (PfRoleVo)roleVos.get(i);
                roleName.append(roleVo.getRoleName());
                if (i == roleVos.size() - 1) continue;
                roleName.append(",");
            }
            map.put("roleName", roleName);
            if (userInfo.isAdmin()) {
                this.sendJson(map);
                return null;
            }
            if (StringUtils.isBlank((String)roleIds)) {
                return null;
            }
            for (String roleId : roleIds.split(",")) {
                roleId = roleId.substring(1, roleId.length() - 1);
                if (!StringUtils.isNotBlank((String)this.resourcekey)) continue;
                permissionList.addAll(this.permissionService.getPermissions(this.resourcekey, roleId));
            }
            if (permissionList.size() > 0) {
                for (Permission permission : permissionList) {
                    if (perms.contains(permission.getOperation())) continue;
                    perms.add(permission.getOperation());
                }
                map.put("perms", perms);
            }
            this.sendJson(map);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String save() throws IOException {
        try {
            this.doSave(this.ydxcPerms, this.ydxcRevoke);
            this.doSave(this.zfxcPerms, this.zfxcRevoke);
            this.doSave(this.bgdcPerms, this.bgdcRevoke);
        }
        catch (Exception e) {
            this.logger.error("\u6388\u6743\u4fdd\u5b58\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendError("\u6388\u6743\u4fdd\u5b58\u5f02\u5e38" + e.getLocalizedMessage());
            return null;
        }
        this.sendOk("OK");
        return null;
    }

    private void doSave(List<Permission> perms, List<Permission> revokePerms) throws Exception {
        if (revokePerms != null) {
            ArrayList<Permission> revokePerm = new ArrayList<Permission>();
            for (Permission permission : revokePerms) {
                List granted = this.permissionService.getPermissions(permission.getResourceKey(), this.roleId);
                for (Permission per : granted) {
                    if (!per.getId().equals(permission.getId()) && !per.getOperation().equals(permission.getOperation())) continue;
                    revokePerm.add(per);
                }
            }
            this.permissionService.revoke(revokePerm.toArray(new Permission[0]));
        }
        if (perms != null) {
            ArrayList<Permission> permissions = new ArrayList<Permission>();
            for (Permission permission : perms) {
                String operation = permission.getOperation();
                if (!StringUtils.isNotBlank((String)operation)) continue;
                Permission permission1 = new Permission(permission.getResourceKey(), this.roleId, operation);
                if (this.permissionService.hasPermission(permission.getResourceKey(), this.roleId, operation)) continue;
                permissions.add(permission1);
            }
            this.permissionService.grant(permissions.toArray(new Permission[0]));
        }
    }

    public String roles() throws Exception {
        List roles = this.userService.getRoleList();
        this.sendJson((Object)roles);
        return null;
    }

    public String validate() throws Exception {
        PfUserVo pfUserVo = this.userService.getUserVo(this.userId);
        if (StringUtils.isNotBlank((String)this.orginalPwd)) {
            String password = Md5Util.Build((String)this.orginalPwd);
            if (password.equals(pfUserVo.getLoginPassWord())) {
                this.sendOk("");
            } else {
                this.sendError("");
            }
        }
        return null;
    }

    public String modify() throws Exception {
        if (StringUtils.isBlank((String)this.newPwd)) {
            this.logger.error("\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
            this.sendError("\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
            return null;
        }
        try {
            boolean b = this.userService.savePassWord(this.userId, this.newPwd);
            if (b) {
                this.sendOk("\u4fee\u6539\u6210\u529f!");
            }
        }
        catch (Exception e) {
            this.sendError(e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getOrginalPwd() {
        return this.orginalPwd;
    }

    public void setOrginalPwd(String orginalPwd) {
        this.orginalPwd = orginalPwd;
    }

    public String getNewPwd() {
        return this.newPwd;
    }

    public void setNewPwd(String newPwd) {
        this.newPwd = newPwd;
    }
}

