/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.service.impl;

import com.gtis.emapserver.entity.Xfqkb;
import com.gtis.emapserver.entity.Xxgksqs;
import com.gtis.emapserver.service.GISManager;
import com.gtis.emapserver.service.LedgerService;
import com.gtis.emapserver.service.WorkflowService;
import com.gtis.emapserver.service.impl.BaseLogger;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class WorkflowServiceImpl
extends BaseLogger
implements WorkflowService {
    private static final String WF_TYPE_XFDJ = "xfdj";
    private static final String WF_TYPE_XXGK = "xxgk";
    private static final String WF_KEY_PROID = "proid";
    private static final String STATE_NEW = "\u65b0\u5efa";
    private static final String STATE_REPORT = "\u4e0a\u62a5";
    private static final String STATE_SETTLE = "\u529e\u7ed3";
    private static final String STATE_BACK = "\u9000\u56de";
    private static final String SE_OBJECTID_FIELD = "OBJECTID";
    @Autowired
    private GISManager gisManager;
    @Autowired
    private LedgerService ledgerService;

    public boolean editPlot(String proid, String type, String primaryKey, String layerName, String dataSource, Map<String, Object> columns) {
        if (this.isNull((Object)proid) || this.isNull((Object)type)) {
            return false;
        }
        boolean success = false;
        try {
            HashMap<String, String> proMap = new HashMap<String, String>();
            if (type.equals(WF_TYPE_XFDJ)) {
                Xfqkb xfqkb = this.ledgerService.findXfqkb(proid);
                proMap.put(WF_KEY_PROID, xfqkb.getProjectId());
                this.entity2Map((Object)xfqkb, proMap);
            } else if (type.equals(WF_TYPE_XXGK)) {
                Xxgksqs xxgksqs = this.ledgerService.findXxgksqs(proid);
                proMap.put(WF_KEY_PROID, xxgksqs.getProjectId());
                this.entity2Map((Object)xxgksqs, proMap);
            } else {
                proMap.put(WF_KEY_PROID.toUpperCase(), proid);
            }
            if (!proMap.isEmpty()) {
                columns.putAll(proMap);
            }
            success = this.isNull((Object)primaryKey) ? this.gisManager.getGISService().insert(layerName, columns, dataSource) : this.gisManager.getGISService().update(layerName, primaryKey, columns, dataSource);
        }
        catch (Exception e) {
            this.logger.error(this.getMessage("edit.error", new Object[]{e.getLocalizedMessage()}));
            throw new RuntimeException(this.getMessage("edit.error", new Object[]{e.getLocalizedMessage()}));
        }
        return success;
    }

    public boolean changeState(String proid, int state, String stateField, String layerName, String dataSource) {
        boolean success = false;
        if (this.isNull((Object)proid)) {
            return false;
        }
        try {
            String where = "proid= '" + proid + "'";
            List results = this.gisManager.getGISService().query(layerName, where, null, false, dataSource);
            if (results.size() == 0) {
                this.logger.info(this.getMessage("query.none", new Object[0]));
                return false;
            }
            HashMap<String, String> columns = new HashMap<String, String>();
            switch (state) {
                case 0: {
                    columns.put(stateField, STATE_NEW);
                    break;
                }
                case 1: {
                    columns.put(stateField, STATE_REPORT);
                    break;
                }
                case 2: {
                    columns.put(stateField, STATE_SETTLE);
                    break;
                }
                case 3: {
                    columns.put(stateField, STATE_BACK);
                }
            }
            for (int i = 0; i < results.size(); ++i) {
                Map item = (Map)results.get(i);
                String pk = MapUtils.getString((Map)item, (Object)SE_OBJECTID_FIELD);
                success = this.gisManager.getGISService().update(layerName, pk, columns, dataSource);
            }
            return success;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public void entity2Map(Object entity, Map desMap) throws IllegalAccessException {
        if (this.isNull(entity) || this.isNull((Object)desMap)) {
            return;
        }
        try {
            Class<?> c = entity.getClass();
            List<Field> fields = Arrays.asList(c.getDeclaredFields());
            for (int i = 0; i < fields.size(); ++i) {
                Field field = fields.get(i);
                field.setAccessible(true);
                Object value = field.get(entity);
                if (this.isNull(value) || value.equals(0.0)) continue;
                desMap.put(field.getName().toUpperCase(), value);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }
}

