/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.service.impl;

import com.gtis.common.Page;
import com.gtis.emapserver.dao.GDDKDao;
import com.gtis.emapserver.entity.DJDK;
import com.gtis.emapserver.entity.GDDK;
import com.gtis.emapserver.service.GISManager;
import com.gtis.emapserver.service.WarnService;
import com.gtis.emapserver.service.impl.BaseLogger;
import com.gtis.emapserver.utils.EnvContext;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class WarnServiceImpl
extends BaseLogger
implements WarnService {
    @Autowired
    private GDDKDao gddkDao;
    @Autowired
    private GISManager gisManager;
    @Autowired
    private EnvContext envContext;
    private static final String TYPE_IDLELAND = "idleLand";
    private static final String TYPE_ILLEGALENTERPRISE = "illegalEnterprise";
    private static final String TYPE_MORTGAGEEXPIRE = "mortgageExpire";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    public Page<GDDK> getPages(int start, int limit, Map<String, ?> condition, String type) {
        assert (type != null);
        try {
            if (TYPE_IDLELAND.equals(type)) {
                return this.gddkDao.getIdleLandPages(start, limit, condition);
            }
            if (TYPE_ILLEGALENTERPRISE.equals(type)) {
                return this.gddkDao.getIllegalEnterprisePages(start, limit, condition);
            }
            if (TYPE_MORTGAGEEXPIRE.equals(type)) {
                return this.gddkDao.getMortgageExpirePages(start, limit, condition);
            }
            throw new RuntimeException("type is not found!");
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public String update(Object obj, String type) {
        try {
            if (TYPE_IDLELAND.equals(type)) {
                return this.updateIdleLand((GDDK)obj);
            }
            if (TYPE_ILLEGALENTERPRISE.equals(type)) {
                return this.updateIllegalEnterprise((GDDK)obj);
            }
            if (TYPE_MORTGAGEEXPIRE.equals(type)) {
                return this.updateMortgageExpire((DJDK)obj);
            }
            throw new RuntimeException("type is not found!");
        }
        catch (RuntimeException e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public int count(String type, Map<String, ?> condition) {
        try {
            if (TYPE_IDLELAND.equals(type)) {
                return this.gddkDao.countIdleLand(condition);
            }
            if (TYPE_ILLEGALENTERPRISE.equals(type)) {
                return this.gddkDao.countIllegalEnterprise(condition);
            }
            if (TYPE_MORTGAGEEXPIRE.equals(type)) {
                return this.gddkDao.countMortgageExpire(condition);
            }
            throw new RuntimeException("type is not found!");
        }
        catch (RuntimeException e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public boolean update2(Object obj, String type) {
        boolean success = false;
        Map<String, String> map = new HashMap<String, Object>();
        try {
            if (type.equals(TYPE_IDLELAND) || type.equals(TYPE_ILLEGALENTERPRISE)) {
                GDDK gddk = (GDDK)obj;
                String layerName = String.valueOf(this.envContext.getEnv("sde.gddk.layer"));
                if (type.equals(TYPE_IDLELAND)) {
                    map.put("SJKGSJ", sdf.format(gddk.getSjkgsj()));
                    map.put("SJJGSJ", sdf.format(gddk.getSjjgsj()));
                } else {
                    map = gddk.toMap();
                }
                success = this.gisManager.getGISService().update(layerName, gddk.getObjectId(), map, null);
            } else {
                DJDK djdk = (DJDK)obj;
                String layerName = String.valueOf(this.envContext.getEnv("sde.djdk.layer"));
                map.put("DYJE", (String)((Object)Double.valueOf(djdk.getDyje())));
                if (!this.isNull((Object)djdk.getDydqsj())) {
                    map.put("DYDQSJ", sdf.format(djdk.getDydqsj()));
                }
                map.put("DYLX", djdk.getDylx());
                success = this.gisManager.getGISService().update(layerName, djdk.getObjectId(), map, null);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return success;
    }

    public String updateIdleLand(GDDK gddk) {
        this.gddkDao.updateIdleLand(gddk);
        return gddk.getObjectId();
    }

    public String updateIllegalEnterprise(GDDK gddk) {
        this.gddkDao.updateIllegalEnterprise(gddk);
        return gddk.getObjectId();
    }

    public String updateMortgageExpire(DJDK djdk) {
        this.gddkDao.updateMortgageExpire(djdk);
        return djdk.getObjectId();
    }
}

