/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.service.impl;

import com.gtis.common.Page;
import com.gtis.emapserver.dao.HYDKDao;
import com.gtis.emapserver.dao.JCTBDao;
import com.gtis.emapserver.dao.LBGDDao;
import com.gtis.emapserver.dao.WFYDDao;
import com.gtis.emapserver.dao.XfqkbDao;
import com.gtis.emapserver.dao.XxgksqsDao;
import com.gtis.emapserver.entity.HYDK;
import com.gtis.emapserver.entity.JCTB;
import com.gtis.emapserver.entity.WFYD;
import com.gtis.emapserver.entity.Xfqkb;
import com.gtis.emapserver.entity.Xxgksqs;
import com.gtis.emapserver.service.GISManager;
import com.gtis.emapserver.service.LedgerService;
import com.gtis.emapserver.service.impl.BaseLogger;
import com.gtis.emapserver.utils.EnvContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class LedgerServiceImpl
extends BaseLogger
implements LedgerService {
    @Autowired
    private JCTBDao jctbDao;
    @Autowired
    private XfqkbDao xfqkbDao;
    @Autowired
    private XxgksqsDao xxgksqsDao;
    @Autowired
    private WFYDDao wfydDao;
    @Autowired
    private HYDKDao hydkDao;
    @Autowired
    private LBGDDao lbgdDao;
    @Autowired
    private EnvContext envContext;
    @Autowired
    private GISManager gisManager;
    private static final String TYPE_JCTB = "jctb";
    private static final String TYPE_XFQKB = "xfqkb";
    private static final String TYPE_WFYD = "wfyd";
    private static final String TYPE_HYDK = "hydk";
    private static final String TYPE_LBGD = "lbgd";

    public Page getLedgerPages(int start, int limit, Map<String, ?> condition, String type) {
        assert (type != null);
        if (type.equals(TYPE_JCTB)) {
            return this.jctbDao.getPages(start, limit, condition);
        }
        if (type.equals(TYPE_XFQKB)) {
            return this.xfqkbDao.getPages(start, limit, condition);
        }
        if (type.equals(TYPE_WFYD)) {
            return this.wfydDao.getPages(start, limit, condition);
        }
        if (type.equals(TYPE_HYDK)) {
            return this.hydkDao.getPages(start, limit, condition);
        }
        if (type.equals(TYPE_LBGD)) {
            return this.lbgdDao.getPages(start, limit, condition);
        }
        throw new RuntimeException("type is not found!");
    }

    public List getLedgerEntities(Map<String, ?> condition, String type) {
        assert (type != null);
        if (type.equals(TYPE_JCTB)) {
            return this.jctbDao.getEntities(condition);
        }
        if (type.equals(TYPE_XFQKB)) {
            return this.xfqkbDao.getEntities(condition);
        }
        if (type.equals(TYPE_WFYD)) {
            return this.wfydDao.getEntities(condition);
        }
        if (type.equals(TYPE_HYDK)) {
            return this.hydkDao.getEntities(condition);
        }
        if (type.equals(TYPE_LBGD)) {
            return this.lbgdDao.getEntities(condition);
        }
        throw new RuntimeException("type is not found!");
    }

    public Map<String, List> getExcelMap(List entities, String type) {
        assert (type != null);
        HashMap<String, List> result = new HashMap<String, List>();
        if (type.equals(TYPE_JCTB)) {
            ArrayList sheet1 = new ArrayList();
            ArrayList sheet2 = new ArrayList();
            for (int i = 0; i < entities.size(); ++i) {
                ArrayList<Object> list1 = new ArrayList<Object>();
                ArrayList<Object> list2 = new ArrayList<Object>();
                JCTB jctb = (JCTB)entities.get(i);
                list1.add(i + 1);
                list1.add(jctb.getJcbh());
                list1.add(jctb.getJcmj());
                list1.add(jctb.getTblx());
                list1.add(jctb.getDlyt());
                list1.add(jctb.getBgfw());
                list2.add(i + 1);
                list2.add(jctb.getJcbh());
                list2.add(jctb.getTblx());
                list2.add(jctb.getDlkd());
                list2.add(jctb.getJcmj());
                list2.add(jctb.getBz());
                sheet1.add(list1);
                sheet2.add(list2);
            }
            if (sheet1.size() > 0) {
                result.put("sheet1", sheet1);
            }
            if (sheet2.size() > 0) {
                result.put("sheet2", sheet2);
            }
        }
        return result;
    }

    public List<Map> getExcelList(List entities, String type) {
        return null;
    }

    public Xfqkb findXfqkb(String id) {
        return (Xfqkb)this.xfqkbDao.find((Serializable)((Object)id));
    }

    public Xxgksqs findXxgksqs(String id) {
        return (Xxgksqs)this.xxgksqsDao.find((Serializable)((Object)id));
    }

    public boolean update(Object obj, String type) {
        boolean success = false;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            if (type.equals(TYPE_HYDK)) {
                HYDK hydk = (HYDK)obj;
                String layerName = String.valueOf(this.envContext.getEnv("sde.hydk.layer"));
                if (this.isNull((Object)hydk.getTdzhqc())) {
                    map.put("TDZHQC", hydk.getTdzhqc());
                    success = this.gisManager.getGISService().update(layerName, hydk.getObjectId(), map, null);
                }
            } else if (type.equals(TYPE_WFYD)) {
                WFYD wfyd = (WFYD)obj;
                String layerName = String.valueOf(this.envContext.getEnv("sde.wfyd.layer"));
                if (!this.isNull((Object)wfyd.getSfxc())) {
                    map.put("SFXC", wfyd.getSfxc());
                    success = this.gisManager.getGISService().update(layerName, wfyd.getObjectId(), map, null);
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return success;
    }
}

