/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.service.impl;

import com.esri.sde.sdk.client.SeLayer;
import com.esri.sde.sdk.pe.PeProjectionException;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.emapserver.core.event.GeometryServiceException;
import com.gtis.emapserver.entity.Document;
import com.gtis.emapserver.service.GeometryService;
import com.gtis.emapserver.service.impl.BaseLogger;
import com.gtis.emapserver.utils.SRTransformations;
import com.gtis.emapserver.utils.ZipUtils;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKTReader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class GeometryServiceImpl
extends BaseLogger
implements GeometryService {
    public static final String TYPE = "type";
    public static final String FEATURE = "Feature";
    public static final String FEATURE_COLLECTION = "FeatureCollection";
    public static final String GEOMETRY_COLLECTION = "GeometryCollection";
    private static final String WKID = "wkid";
    private static final String WKT = "wkt";
    private static final String TEMP_PIX = "TMP_";
    private static final String DOTS = ".";
    private GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();

    public CoordinateReferenceSystem getCRSByWKTString(String wktCRS) {
        try {
            return CRS.parseWKT((String)SRTransformations.getCoordinateSystem((String)wktCRS).toString());
        }
        catch (Exception e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.CRS_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
        catch (PeProjectionException e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.CRS_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public CoordinateReferenceSystem getCRSBySRID(String srid) {
        try {
            return this.getCRSByWKTString(SRTransformations.getCoordinateSystem((int)Integer.valueOf(srid)).toString());
        }
        catch (PeProjectionException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public CoordinateReferenceSystem getSeLayerCRS(SeLayer layer) {
        return this.getCRSByWKTString(layer.getCoordRef().getCoordSysDescription());
    }

    public Geometry readWKT(String wkt) throws GeometryServiceException {
        try {
            return new WKTReader(this.geometryFactory).read(wkt);
        }
        catch (Exception e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.WKT_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public Object readUnTypeGeoJSON(String geoJSON) throws GeometryServiceException {
        try {
            return null;
        }
        catch (Exception e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.GEOJSON_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public Geometry project(Geometry geometry, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws GeometryServiceException {
        return this.projectByAGS(geometry, sourceCRS, targetCRS);
    }

    public Geometry projectByAGS(Geometry geometry, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) {
        try {
            return SRTransformations.project((Geometry)geometry, (String)sourceCRS.toWKT(), (String)targetCRS.toWKT());
        }
        catch (PeProjectionException e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.PROJECT_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public SimpleFeatureType getFeatureType(Map<String, Object> value) {
        String[] keys;
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName(FEATURE);
        for (String key : keys = value.keySet().toArray(new String[0])) {
            if ("SHAPE".equals(key)) {
                typeBuilder.add("geometry", Geometry.class);
                continue;
            }
            if ("crs".equals(key)) {
                typeBuilder.add("crs", String.class, (CoordinateReferenceSystem)value.get(key));
                continue;
            }
            typeBuilder.add(key, value.get(key) != null ? value.get(key).getClass() : String.class);
        }
        return typeBuilder.buildFeatureType();
    }

    public SimpleFeature map2SimpleFeature(Map<String, Object> value, CoordinateReferenceSystem srcCRS, CoordinateReferenceSystem destCRS) {
        String[] keys;
        Geometry geometry;
        Geometry geometry2 = geometry = value.containsKey("SHAPE") ? this.readWKT((String)value.get("SHAPE")) : null;
        if (geometry != null && srcCRS != null && destCRS != null) {
            geometry = this.project(geometry, srcCRS, destCRS);
        }
        SimpleFeatureType featureType = this.getFeatureType(value);
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
        for (String key : keys = value.keySet().toArray(new String[0])) {
            if ("SHAPE".equals(key)) {
                featureBuilder.add((Object)geometry);
                continue;
            }
            if ("crs".equals(key)) {
                featureBuilder.add(value.get("crs"));
                continue;
            }
            featureBuilder.add(value.get(key) != null ? value.get(key) : "");
        }
        return featureBuilder.buildFeature(FEATURE.concat(UUIDGenerator.generate()));
    }

    public FeatureCollection list2FeatureCollection(List<Map<String, Object>> value, CoordinateReferenceSystem srcCRS, CoordinateReferenceSystem destCRS) {
        DefaultFeatureCollection collection = new DefaultFeatureCollection(null, null);
        for (Map<String, Object> item : value) {
            try {
                collection.add(this.map2SimpleFeature(item, srcCRS, destCRS));
            }
            catch (Exception e) {
                this.logger.info(this.getMessage("list.2featureCollection.false", new Object[0]), (Object)e.getLocalizedMessage());
            }
        }
        return collection;
    }

    public File createShpZip(String folderPath, List<Map<String, Object>> values, CoordinateReferenceSystem crs) {
        try {
            String[] keys;
            File folderFile = new File(folderPath);
            if (!folderFile.exists()) {
                folderFile.mkdir();
            }
            String filePath = folderFile.getPath().concat("\\" + folderFile.getName().concat(DOTS.concat(Document.Type.shp.name())));
            File file = new File(filePath);
            HashMap<String, URL> params = new HashMap<String, URL>();
            params.put(ShapefileDataStoreFactory.URLP.key, file.toURI().toURL());
            ShapefileDataStore ds = (ShapefileDataStore)new ShapefileDataStoreFactory().createNewDataStore(params);
            Map<String, Object> value = values.get(0);
            SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
            typeBuilder.setName("shapefile");
            for (String key : keys = value.keySet().toArray(new String[0])) {
                if ("SHAPE".equals(key)) {
                    typeBuilder.add("the_geom", Polygon.class);
                    continue;
                }
                if ("crs".equals(key)) {
                    typeBuilder.add("crs", String.class, (CoordinateReferenceSystem)value.get(key));
                    continue;
                }
                typeBuilder.add(key, value.get(key) != null ? value.get(key).getClass() : String.class);
            }
            if (!this.isNull((Object)crs)) {
                typeBuilder.setCRS(crs);
            } else {
                typeBuilder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            }
            ds.createSchema(typeBuilder.buildFeatureType());
            ds.setStringCharset(Charset.forName("GBK"));
            FeatureWriter writer = ds.getFeatureWriter(ds.getTypeNames()[0], Transaction.AUTO_COMMIT);
            for (Map<String, Object> item : values) {
                Geometry geometry;
                SimpleFeature feature = (SimpleFeature)writer.next();
                Geometry geometry2 = geometry = item.containsKey("SHAPE") ? this.readWKT((String)item.get("SHAPE")) : null;
                if (this.isNull(geometry)) continue;
                feature.setAttribute("the_geom", (Object)this.geometryFactory.createGeometry(geometry));
                for (String key : item.keySet()) {
                    if (key.equals("SHAPE") || key.equals("crs")) continue;
                    feature.setAttribute(key, item.get(key));
                }
            }
            writer.write();
            writer.close();
            ds.dispose();
            File zipFile = ZipUtils.doZip((String)folderPath, null);
            if (zipFile.exists()) {
                return zipFile;
            }
        }
        catch (IOException e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return null;
    }
}

