/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.service.impl;

import com.alibaba.fastjson.JSON;
import com.gtis.common.Page;
import com.gtis.emapserver.core.service.TemplateService;
import com.gtis.emapserver.dao.FunctionDao;
import com.gtis.emapserver.dao.ServiceDao;
import com.gtis.emapserver.entity.Configuration;
import com.gtis.emapserver.entity.Function;
import com.gtis.emapserver.entity.Service;
import com.gtis.emapserver.service.ConfigService;
import com.gtis.emapserver.utils.AppPropertyUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@org.springframework.stereotype.Service
public class ConfigServiceImpl
implements ConfigService {
    @Autowired
    private ServiceDao serviceDao;
    @Autowired
    private FunctionDao functionDao;
    @Autowired
    private TemplateService templateService;

    public int servicesCount() {
        return this.serviceDao.count();
    }

    public Service findService(String pk) {
        return (Service)this.serviceDao.find((Serializable)((Object)pk));
    }

    public String insert(Service service) {
        this.serviceDao.insert((Object)service);
        return service.getId();
    }

    public Service getServiceByUrl(Service service) {
        return this.serviceDao.getServiceByUrl(service);
    }

    public String update(Service service) {
        this.serviceDao.update((Object)service);
        return service.getId();
    }

    public Function findFunction(String pk) {
        return (Function)this.functionDao.find((Serializable)((Object)pk));
    }

    public String insert(Function function) {
        this.functionDao.insert((Object)function);
        return function.getId();
    }

    public String update(Function function) {
        this.functionDao.update((Object)function);
        return function.getId();
    }

    public String delete(String serviceId) {
        this.serviceDao.deleteService((Serializable)((Object)serviceId));
        return serviceId;
    }

    public List<Function> getFunctions(String serviceId) {
        return this.functionDao.getFunctions(serviceId);
    }

    public Function getFunctionByType(Function function) {
        return this.functionDao.getFunctionByType(function);
    }

    public List<Service> getAllService() {
        return this.serviceDao.getAllDicts();
    }

    public List<Service> getService(int start, int limit, Map<String, ?> condition) {
        return this.serviceDao.getEntities(start, limit, condition);
    }

    public Page<Service> getServicePages(int start, int limit, Map<String, ?> condition) {
        return this.serviceDao.getPages(start, limit, condition);
    }

    public String getConfigContent() {
        return this.templateService.getTemplate((String)AppPropertyUtils.getAppEnv((String)"map.config"), "utf-8");
    }

    public String getWidgetsContent() {
        return this.templateService.getTemplate("widgets.json");
    }

    public Configuration getConfig() {
        return (Configuration)JSON.parseObject((String)this.getConfigContent(), Configuration.class);
    }

    public String saveConfig(String content) {
        return this.templateService.modify((String)AppPropertyUtils.getAppEnv((String)"map.config"), content);
    }

    public Configuration saveConfig(Configuration configuration) {
        return (Configuration)JSON.parseObject((String)this.saveConfig(JSON.toJSONString((Object)configuration)), Configuration.class);
    }
}

