/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.service.impl;

import com.gtis.emapserver.core.ogc.impl.GeometryOperationImpl;
import com.gtis.emapserver.core.support.spring.ApplicationContextHelper;
import com.gtis.emapserver.dao.SpatialDao;
import com.gtis.emapserver.dao.impl.SDEDaoImpl;
import com.gtis.emapserver.service.GISService;
import com.gtis.emapserver.utils.ArrayUtils;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArcSDEServiceImpl
implements GISService {
    private SpatialDao dao;

    public void initialize() {
        this.dao = (SpatialDao)ApplicationContextHelper.createBean(SDEDaoImpl.class);
    }

    public Map<String, ?> intersectAnalysis(String[] layerNames, String wktPolygon, String[] returnFields) {
        if (ArrayUtils.empty((String[])layerNames)) {
            return null;
        }
        HashMap<String, List> result = new HashMap<String, List>();
        for (String layerName : layerNames) {
            if (wktPolygon.indexOf("GeometryCollection") > -1) {
                ArrayList list = new ArrayList();
                GeometryOperationImpl geometryOperation = new GeometryOperationImpl();
                try {
                    GeometryCollection geometryCollection = geometryOperation.readGeoCollection(wktPolygon);
                    for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                        Polygon polygon = (Polygon)geometryCollection.getGeometryN(i);
                        list.addAll(this.dao.intersectByPolygon(layerName, polygon.toString(), returnFields));
                    }
                    result.put(layerName, list);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                continue;
            }
            result.put(layerName, this.dao.intersectByPolygon(layerName, wktPolygon, returnFields));
        }
        return result;
    }

    public Map<String, ?> intersectAnalysis(String[] layerNames, String wktPolygon, String[] returnFields, String[] dbSources) {
        if (ArrayUtils.empty((String[])layerNames)) {
            return null;
        }
        HashMap<String, List> result = new HashMap<String, List>();
        for (int i = 0; i < layerNames.length; ++i) {
            if (wktPolygon.indexOf("GeometryCollection") > -1) {
                GeometryOperationImpl geometryOperation = new GeometryOperationImpl();
                try {
                    GeometryCollection geometryCollection = geometryOperation.readGeoCollection(wktPolygon);
                    for (int j = 0; j < geometryCollection.getNumGeometries(); ++j) {
                        Polygon polygon = (Polygon)geometryCollection.getGeometryN(j);
                        result.put(layerNames[i], this.dao.intersectByPolygon(layerNames[i], polygon.toString(), returnFields));
                    }
                    continue;
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            result.put(layerNames[i], this.dao.intersectByPolygon(layerNames[i], wktPolygon, returnFields, dbSources[i]));
        }
        return result;
    }

    public boolean insert(String layerName, Map<String, Object> columns, String dbSource) {
        return this.dao.insert(layerName, columns, dbSource);
    }

    public boolean update(String layerName, String primaryKey, Map<String, Object> columns, String dbSource) {
        return this.dao.update(layerName, primaryKey, columns, dbSource);
    }

    public boolean delete(String layerName, String primaryKey, String dbSource) {
        return this.dao.delete(layerName, primaryKey, dbSource);
    }

    public List query(String layerName, String where, String[] columns, boolean returnGeometry, String dbSource) {
        return this.dao.query(layerName, where, columns, returnGeometry, dbSource);
    }

    public List query(String layerName, String wktString, String[] columns, String dbSource) {
        return this.dao.query(layerName, wktString, columns, dbSource);
    }

    public List immediateSearch(String layerName, String[] fields, String keyword) {
        return this.dao.immediateSearch(layerName, fields, keyword);
    }

    public List fullSearch(String layerName, String[] fields, String keyword) {
        return this.dao.fullSearch(layerName, fields, keyword);
    }

    public CoordinateReferenceSystem getLayerCRS(String layerName, String dataSource) {
        return this.dao.getLayerCRS(layerName, dataSource);
    }
}

