/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.core.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.gtis.emapserver.service.impl.BaseLogger;
import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.ActionContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;
import org.springframework.util.FileCopyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseAction
extends BaseLogger
implements Action {
    public String execute() throws Exception {
        return "success";
    }

    protected String sendString(String result) throws IOException {
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setCharacterEncoding("utf-8");
        response.setContentType("text/html;charset=utf-8");
        response.getWriter().write(result);
        return "none";
    }

    protected String sendMap(Map<String, Object> result) {
        ActionContext.getContext().getSession().putAll(result);
        return "success";
    }

    protected String sendJson(Object param) throws IOException {
        return this.sendString(this.renderJson(param));
    }

    protected String sendError(String message) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("msg", message);
        map.put("success", false);
        return this.sendString(this.renderJson(map));
    }

    protected String sendSuccess(Object value) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("result", value);
        map.put("success", true);
        return this.sendString(this.renderJson(map));
    }

    protected String sendOk(String message) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("msg", message);
        map.put("success", true);
        return this.sendString(this.renderJson(map));
    }

    protected String renderJson(Object param) {
        return JSON.toJSONString((Object)param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullBooleanAsFalse, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullBooleanAsFalse});
    }

    protected void sendFile(File file) throws IOException {
        HttpServletResponse response = ServletActionContext.getResponse();
        if (file != null && file.exists()) {
            long modified = file.lastModified();
            response.addHeader("Content-Disposition", "attachment; filename=" + file.getName());
            response.setDateHeader("Last-Modified", modified);
            response.setContentLength((int)file.length());
            FileCopyUtils.copy((InputStream)new FileInputStream(file), (OutputStream)response.getOutputStream());
        } else {
            response.sendError(404, "file not found");
        }
    }

    protected void sendFile(InputStream inputStream, HttpServletResponse response, String fileName) throws IOException {
        if (inputStream == null || response == null) {
            return;
        }
        if (inputStream.available() > 0) {
            response.addHeader("Content-Disposition", "attachment; filename=" + fileName);
            response.setDateHeader("Last-Modified", new Date().getTime());
            response.setContentLength(inputStream.available());
            FileCopyUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
        } else {
            response.sendError(404, "request file not found");
        }
    }

    protected void sendFile(InputStream inputStream, String fileName) throws IOException {
        HttpServletResponse response = ServletActionContext.getResponse();
        if (inputStream == null || response == null) {
            return;
        }
        if (inputStream.available() > 0) {
            response.addHeader("Content-Disposition", "attachment; filename=" + fileName);
            response.setDateHeader("Last-Modified", new Date().getTime());
            response.setContentLength(inputStream.available());
            FileCopyUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
        } else {
            response.sendError(404, "request file not found");
        }
    }
}

