<#---->

<#macro html title="" import="">
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html;charset=UTF-8"/>
    <title>${title}</title>
    <#list import?split(",") as lib>
        <#switch lib>
            <#case "base">
                <@script name="js/base.js"></@script>
                <@style name="css/base.css"></@style>
                <#break />
            <#case "main">
                <@script name="js/main.js"></@script>
                <@style name="css/main.css"></@style>
                <#break />
            <#case "ext">
                <@style name="js/ext/resources/css/ext-all-gray.css"></@style>
                <@script name="js/ext/ext-all-dev.js"></@script>
                <@script name="js/ext/ext-lang-zh_CN.js"></@script>
                <#break />
            <#case "jquery">
                <@script name="js/jquery/jquery-1.7.2.min.js"></@script>
                <@script name="js/jquery/jquery.blockUI.js"></@script>
                <@script name="js/jquery/My97DatePicker/WdatePicker.js"></@script>
                <#break />
            <#case "swf">
                <@script name="js/swfobject.js"></@script>
                <#break />
            <#default>
                <@script name="js/${lib}.js"></@script>
                <@style name="css/${lib}.css"></@style>
        </#switch>
    </#list>
</head>
<body>
    <#nested />
</body>
</html>
</#macro>

<#macro swf title="" swfname="">
    <@com.html title="${title}" import="swf">
    <style type="text/css" media="screen">
        html, body {
            height: 100%;
        }
        body {
            margin: 0;
            padding: 0;
            overflow: auto;
            text-align: center;
            background-color: #25639c;
        }
        object:focus {
            outline: none;
        }
        #flashContent {
            top: 50%;
            width: 360px;
            margin: 0px auto;
        }
        #flashContent p {
            color: #ffffff;
        }
    </style>

    <script type="text/javascript">
        var swfVersionStr = "11.1.0";
        var xiSwfUrlStr = "playerProductInstall.swf";
        var flashvars = {};
        var params = {};
        params.quality = "high";
        params.bgcolor = "#ffffff";
        params.allowscriptaccess = "sameDomain";
        params.allowfullscreen = "true";
        var attributes = {};
        attributes.id = "${swfname}";
        attributes.name = "${swfname}";
        attributes.align = "middle";
        swfobject.embedSWF(
                "/emapserver/flash/${swfname}.swf", "flashContent",
                "100%", "100%",
                swfVersionStr, xiSwfUrlStr,
                flashvars, params, attributes);
        swfobject.createCSS("#flashContent", "display:block;text-align:left;");
    </script>

    <div id="flashContent">
        <p>
            亲，难道你不知道看Flash要装Adobe Flash Player的么，记得安装11.1.0以上的版本哦！<br/>
            点击以下链接即可下载安装哦~<br/>安装后记得重启浏览器。
        </p>
        <script type="text/javascript">
            var axUrl = "/emapserver/bin/install_flash_player_ax.exe";
            var otherUrl = "/emapserver/bin/install_flash_player.exe";
            var playerUrl = window.ActiveXObject ? axUrl : otherUrl;
            document.write("<a href='" + playerUrl + "'><img src='/emapserver/images/get_flash_player.gif'/> </a>");
        </script>
    </div>
    </@com.html>
</#macro>


<#---->
<#macro script name>
<script src="${base}/${name}" type="text/javascript"></script>
</#macro>

<#macro style name>
<link href="${base}/${name}" type="text/css" media="screen" rel="stylesheet"/>
</#macro>