/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.web.config;

import com.alibaba.fastjson.JSON;
import com.gtis.common.Page;
import com.gtis.emapserver.core.web.BaseAction;
import com.gtis.emapserver.entity.Function;
import com.gtis.emapserver.entity.Service;
import com.gtis.emapserver.entity.dict.Dict;
import com.gtis.emapserver.entity.dict.Item;
import com.gtis.emapserver.service.ConfigService;
import com.gtis.emapserver.service.DictService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

public class ConfigAction
extends BaseAction {
    private String serviceId;
    public String dictId;
    public String dictItemId;
    private int start;
    private int limit;
    private Map condition;
    private String params;
    private String funcitonParams;
    private String dictItemInfo;
    @Autowired
    private ConfigService configService;
    @Autowired
    private DictService dictService;

    public void setFuncitonParams(String funcitonParams) {
        this.funcitonParams = funcitonParams;
    }

    public void setDictItemInfo(String dictItemInfo) {
        this.dictItemInfo = dictItemInfo;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public void services() throws IOException {
        try {
            this.sendJson((Object)this.configService.getServicePages(this.start, this.limit, this.condition));
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u670d\u52a1\u5217\u8868\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendJson((Object)new Page());
        }
    }

    public void removeService() throws IOException {
        try {
            this.sendJson((Object)this.configService.delete(this.serviceId));
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664\u670d\u52a1\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendJson((Object)new Page());
        }
    }

    public void functions() throws IOException {
        this.sendJson((Object)this.configService.getFunctions(this.serviceId));
    }

    public void getFunctionByType() throws IOException {
        Function func = (Function)JSON.parseObject((String)this.funcitonParams, Function.class);
        try {
            this.sendJson((Object)this.configService.getFunctionByType(func));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setCondition(String value) throws UnsupportedEncodingException {
        if (StringUtils.isBlank((String)value)) {
            return;
        }
        value = URLDecoder.decode(value, "utf-8");
        String[] items = value.split(";");
        this.condition = new HashMap();
        ArrayList<String> list = new ArrayList<String>(items.length);
        for (String item : items) {
            if (!StringUtils.isNotBlank((String)item)) continue;
            list.add(item);
        }
        this.condition.put("condition", list);
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public void insertService() throws IOException {
        try {
            Service service = (Service)JSON.parseObject((String)this.params, Service.class);
            if (this.configService.getServiceByUrl(service) == null) {
                this.sendJson((Object)this.configService.insert(service));
            }
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u670d\u52a1\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendJson((Object)new Page());
        }
    }

    public void updateService() throws IOException {
        try {
            Service service = (Service)JSON.parseObject((String)this.params, Service.class);
            this.sendJson((Object)this.configService.update(service));
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u5b57\u5178\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendJson((Object)new Page());
        }
    }

    public void dicts() throws IOException {
        try {
            this.sendJson((Object)this.dictService.getDicts());
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5b57\u5178\u5217\u8868\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendJson((Object)new Page());
        }
    }

    public void saveDict() throws IOException {
        try {
            Dict dict = (Dict)JSON.parseObject((String)this.dictItemInfo, Dict.class);
            if (this.dictService.getDict(dict.getName()) == null) {
                this.sendJson((Object)this.dictService.saveDict(dict));
            }
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u5b57\u5178\u5217\u8868\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendJson((Object)new Page());
        }
    }

    public void updateDict() throws IOException {
        try {
            Dict dict = (Dict)JSON.parseObject((String)this.dictItemInfo, Dict.class);
            this.sendJson((Object)this.dictService.updateDict(dict));
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u5b57\u5178\u5217\u8868\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendJson((Object)new Page());
        }
    }

    public void saveDictItem() throws IOException {
        try {
            Item item = (Item)JSON.parseObject((String)this.params, Item.class);
            this.sendJson((Object)this.dictService.saveDictItem(item));
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u5b57\u5178\u9879\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendJson((Object)new Page());
        }
    }

    public void updateDictItem() throws IOException {
        try {
            Item item = (Item)JSON.parseObject((String)this.params, Item.class);
            this.sendJson((Object)this.dictService.updateDictItem(item));
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u5b57\u5178\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendJson((Object)new Page());
        }
    }

    public void dictItems() throws IOException {
        try {
            this.sendJson((Object)this.dictService.getDictItems(this.dictId));
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5b57\u5178\u9879\u5217\u8868\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendJson((Object)new Page());
        }
    }

    public void removeDict() throws IOException {
        try {
            this.dictService.removeDict(this.dictId);
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664\u5b57\u5178\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendJson((Object)new Page());
        }
    }

    public void removeDictItem() throws IOException {
        try {
            this.dictService.removeDictItem(this.dictItemId);
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664\u5b57\u5178\u9879\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendJson((Object)new Page());
        }
    }

    public void configurations() throws IOException {
        try {
            this.sendString(this.configService.getConfigContent());
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u7ec4\u4ef6\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendError(e.getLocalizedMessage());
        }
    }

    public void saveConfig() throws IOException {
        try {
            this.sendString(this.configService.saveConfig(ServletActionContext.getRequest().getParameter("content")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void widgets() throws IOException {
        try {
            this.sendString(this.configService.getWidgetsContent());
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u7ec4\u4ef6\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.sendError(e.getLocalizedMessage());
        }
    }

    public void insertFunction() {
        Function func = (Function)JSON.parseObject((String)this.params, Function.class);
        if (this.configService.getFunctionByType(func) == null) {
            this.configService.insert(func);
        } else {
            this.configService.update(func);
        }
    }
}

