/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.service.impl;

import com.gtis.emapserver.core.event.DictNoteFoundException;
import com.gtis.emapserver.dao.FunctionDao;
import com.gtis.emapserver.dao.ServiceDao;
import com.gtis.emapserver.entity.Configuration;
import com.gtis.emapserver.entity.Function;
import com.gtis.emapserver.entity.Service;
import com.gtis.emapserver.entity.dict.Dict;
import com.gtis.emapserver.entity.dict.Item;
import com.gtis.emapserver.service.ConfigService;
import com.gtis.emapserver.service.DictService;
import com.gtis.emapserver.service.MapService;
import com.gtis.emapserver.utils.AppPropertyUtils;
import com.gtis.emapserver.utils.DateUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@org.springframework.stereotype.Service
public class MapServiceImpl
implements MapService {
    @Autowired
    private ServiceDao serviceDao;
    @Autowired
    private FunctionDao functionDao;
    @Autowired
    private ConfigService configService;
    @Autowired
    private DictService dictService;

    public Service findService(String serviceId) {
        return (Service)this.serviceDao.find((Serializable)((Object)serviceId));
    }

    public List<Service> getServices(String xzdm) {
        return this.serviceDao.getServices(xzdm);
    }

    public List<Service> getServices(String[] serviceIds) {
        return this.serviceDao.getServices(serviceIds);
    }

    public List<Service> getServices(String xzdm, String[] serviceIds) {
        return this.serviceDao.getServices(xzdm, serviceIds);
    }

    public List<Service> getServices(Map<String, ?> condition) {
        return this.serviceDao.getServices(condition);
    }

    public List<Function> getFunctions(String serviceId) {
        return this.functionDao.getFunctions(serviceId);
    }

    public Function getFunctionByType(Function function) {
        return this.configService.getFunctionByType(function);
    }

    public Configuration getConfig() {
        return this.configService.getConfig();
    }

    public Map<String, Object> getRegionCodeList(String regionCode) {
        String year = (String)AppPropertyUtils.getAppEnv((String)"default.year");
        if (StringUtils.isBlank((String)year)) {
            return null;
        }
        if ("current".equals(year)) {
            year = DateUtils.getCurrentYear();
        }
        String regionCodePerfix = "regionCode_".concat(year).concat("_");
        return this.getOgRegions(regionCode, regionCodePerfix);
    }

    public String getRegionShape(String regionItemId) {
        return this.dictService.getDictItem(regionItemId).getValue();
    }

    private Map<String, Object> getOgRegions(String regionCode, String perfix) {
        Dict root = this.dictService.getDict(perfix.concat(regionCode));
        HashMap<String, Object> region = new HashMap<String, Object>();
        try {
            List regions = this.dictService.getDictItemsByName(perfix.concat(regionCode));
            ArrayList<Map> subRegion = new ArrayList<Map>();
            for (Item item : regions) {
                Map thirdRegion = this.itemToMap(item);
                try {
                    List thirdRegions = this.dictService.getDictItemsByName(perfix.concat(item.getName()));
                    thirdRegion.put("children", this.itemList2MapList(thirdRegions));
                }
                catch (DictNoteFoundException ex) {
                    thirdRegion.put("children", null);
                }
                subRegion.add(thirdRegion);
            }
            region.put("id", root.getId());
            region.put("name", regionCode);
            region.put("title", root.getTitle());
            region.put("children", subRegion);
        }
        catch (DictNoteFoundException ex) {
            throw new DictNoteFoundException(perfix.concat(regionCode));
        }
        return region;
    }

    private Map<String, Object> itemToMap(Item item) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", item.getId());
        map.put("name", item.getName());
        map.put("title", item.getTitle());
        map.put("children", null);
        return map;
    }

    private List<Map> itemList2MapList(List<Item> items) {
        ArrayList<Map> maps = new ArrayList<Map>();
        for (Item item : items) {
            maps.add(this.itemToMap(item));
        }
        return maps;
    }
}

