/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.dao.impl;

import com.esri.sde.sdk.client.SeColumnDefinition;
import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeCoordinateReference;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeFilter;
import com.esri.sde.sdk.client.SeInsert;
import com.esri.sde.sdk.client.SeLayer;
import com.esri.sde.sdk.client.SeObjectId;
import com.esri.sde.sdk.client.SeQuery;
import com.esri.sde.sdk.client.SeQueryInfo;
import com.esri.sde.sdk.client.SeRegistration;
import com.esri.sde.sdk.client.SeRow;
import com.esri.sde.sdk.client.SeShape;
import com.esri.sde.sdk.client.SeShapeFilter;
import com.esri.sde.sdk.client.SeSqlConstruct;
import com.esri.sde.sdk.client.SeState;
import com.esri.sde.sdk.client.SeTable;
import com.esri.sde.sdk.client.SeVersion;
import com.esri.sde.sdk.client.SeXmlDoc;
import com.gtis.emapserver.core.ogc.GeometryOperation;
import com.gtis.emapserver.core.support.ibatis.SDEBaseDao;
import com.gtis.emapserver.dao.SpatialDao;
import com.gtis.emapserver.utils.ArrayUtils;
import java.io.ByteArrayInputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDEDaoImpl
extends SDEBaseDao
implements SpatialDao {
    private static final String ARCSDE_DEFAULT_VERSION = "DEFAULT";
    @Autowired
    private GeometryOperation geometryOperation;

    public List<Map<String, Object>> intersectByPolygon(String layerName, String wktPolygon, String[] returnFields) {
        return this.intersectByPolygon(layerName, wktPolygon, returnFields, null);
    }

    public List<Map<String, Object>> intersectByPolygon(String layerName, String wktPolygon, String[] returnFields, String dbSource) {
        SeConnection connection = this.getConnection(dbSource);
        if (null != connection) {
            try {
                returnFields = ArrayUtils.add2Arrays((String[])returnFields, (String[])new String[]{"OBJECTID", "SHAPE"});
                SeLayer layer = this.getLayer(connection, layerName);
                if (layer != null) {
                    SeShape shape = new SeShape(layer.getCoordRef());
                    shape.generateFromText(wktPolygon);
                    List fResults = this.spatialQuery(connection, shape, layerName, returnFields);
                    if (fResults == null || fResults.size() < 1) {
                        this.logger.info("\u5206\u6790\u65e0\u7ed3\u679c\uff01");
                        return null;
                    }
                    ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
                    HashMap<String, Object> result = null;
                    for (Map item : fResults) {
                        try {
                            SeShape[] shapes;
                            SeShape tShape = (SeShape)item.get("SHAPE");
                            if (tShape == null || (shapes = shape.intersect(tShape)) == null || shapes.length == 0) continue;
                            for (SeShape tmp : shapes) {
                                result = new HashMap<String, Object>();
                                result.putAll(item);
                                result.put("SHAPE", tmp.asText(Integer.MAX_VALUE));
                                result.put("SHAPE_AREA", tmp.getArea());
                                results.add(result);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return results;
                }
            }
            catch (SeException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean edit(String layerName, Map<String, Object> columns, String dbSource) {
        SeConnection connection = this.getConnection(dbSource);
        if (connection != null) {
            try {
                SeLayer layer = this.getLayer(connection, layerName);
                if (layer != null && columns != null) {
                    if (columns.get("SHAPE") != null) {
                        SeShape shape = new SeShape(layer.getCoordRef());
                        shape.generateFromText((String)columns.get("SHAPE"));
                        columns.put("SHAPE", shape);
                    }
                    if (this.isLayerVersioned(connection, layer)) {
                        return this.spatialInsertByVersion(connection, layer.getTableName(), columns);
                    }
                    return this.spatialInsert(connection, layerName, columns);
                }
            }
            catch (SeException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public List immediateSearch(String layerName, String[] fields, String keyword) {
        SeConnection con = this.getConnection(null);
        ArrayList<String> results = null;
        if (con != null) {
            try {
                SeSqlConstruct construct = new SeSqlConstruct(layerName, this.getWhereClause(fields, keyword));
                SeQueryInfo queryInfo = new SeQueryInfo();
                queryInfo.setQueryType(1);
                queryInfo.setColumns(fields);
                queryInfo.setConstruct(construct);
                SeQuery query = new SeQuery(con);
                query.prepareQueryInfo(queryInfo);
                query.execute();
                SeRow row = query.fetch();
                results = new ArrayList<String>();
                for (int i = 0; row != null && i < 20; ++i) {
                    Map map = this.seRow2Map(row);
                    for (String f : fields) {
                        if (String.valueOf(map.get(f)).indexOf(keyword) <= -1) continue;
                        results.add(String.valueOf(map.get(f)));
                        break;
                    }
                    row = query.fetch();
                }
            }
            catch (SeException e) {
                this.logger.error("\u5373\u65f6\u641c\u7d22\u5f02\u5e38\u3010{}\u3011", (Object)e.getSeError().getErrDesc());
            }
            catch (Exception e) {
                this.logger.error("\u5373\u65f6\u641c\u7d22\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            }
        }
        return results;
    }

    private String getWhereClause(String[] fields, String keyword) {
        String or = " or ";
        StringBuilder b = new StringBuilder();
        for (String field : fields) {
            b.append(field);
            b.append(" like '%");
            b.append(keyword);
            b.append("%'");
            b.append(or);
        }
        b.delete(b.length() - or.length(), b.length());
        return b.toString();
    }

    public List fullSearch(String layerName, String[] fields, String keyword) {
        SeConnection connection = this.getConnection(null);
        ArrayList results = null;
        if (connection != null) {
            try {
                SeSqlConstruct construct = new SeSqlConstruct(layerName, this.getWhereClause(fields, keyword));
                SeQueryInfo queryInfo = new SeQueryInfo();
                queryInfo.setQueryType(1);
                queryInfo.setColumns(ArrayUtils.add2Arrays((String[])fields, (String[])new String[]{"SHAPE"}));
                queryInfo.setConstruct(construct);
                SeQuery query = new SeQuery(connection);
                query.prepareQueryInfo(queryInfo);
                query.execute();
                SeRow row = query.fetch();
                results = new ArrayList();
                for (int i = 0; row != null && i < 20; ++i) {
                    Map tmp = this.seRow2Map(row);
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    try {
                        for (Map.Entry e : tmp.entrySet()) {
                            Map.Entry entry = e;
                            String key = (String)entry.getKey();
                            if ("SHAPE".equals(key)) {
                                map.put("SHAPE", ((SeShape)entry.getValue()).getAllCoords());
                                continue;
                            }
                            if (String.valueOf(entry.getValue()).indexOf(keyword) > -1) {
                                map.put(key, entry.getValue());
                                map.put("key", entry.getValue());
                                continue;
                            }
                            map.put(key, entry.getValue());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    results.add(map);
                    row = query.fetch();
                }
            }
            catch (SeException e) {
                this.logger.error("\u5168\u6587\u641c\u7d22\u5f02\u5e38\u3010{}\u3011", (Object)e.getSeError().getErrDesc());
            }
        }
        return results;
    }

    private SeShape getShapeFromWktGeometry(String wktGeometry, int wkid) throws Exception {
        SeShape shape = null;
        try {
            SeCoordinateReference cr = new SeCoordinateReference();
            cr.setCoordSysByDescription(this.geometryOperation.getWKTStringFromSrid(wkid));
            shape = new SeShape(cr);
            shape.generateFromText(wktGeometry);
        }
        catch (Exception e) {
            throw new RuntimeException("\u751f\u6210Shape\u5f02\u5e38\u3010" + e.getLocalizedMessage() + "\u3011");
        }
        return shape;
    }

    private SeShape getShapeFromWktGeometry(String wktGeometry, String crDescription) throws Exception {
        SeShape shape = null;
        try {
            SeCoordinateReference cr = new SeCoordinateReference();
            cr.setCoordSysByDescription(crDescription);
            shape = new SeShape(cr);
            shape.generateFromText(wktGeometry);
        }
        catch (Exception e) {
            throw new RuntimeException("\u751f\u6210Shape\u5f02\u5e38\u3010" + e.getLocalizedMessage() + "\u3011");
        }
        return shape;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean spatialInsert(SeConnection connection, String layerName, Map<String, Object> columns) {
        try {
            SeInsert insert = new SeInsert(connection);
            connection.startTransaction();
            try {
                insert.intoTable(layerName, this.getColumnNames(columns));
                insert.setWriteMode(true);
                SeRow row = insert.getRowToSet();
                this.setRowColumnsValue(row, columns);
                insert.execute();
                connection.commitTransaction();
                boolean bl = true;
                return bl;
            }
            catch (SeException e) {
                e.printStackTrace();
                connection.rollbackTransaction();
                return false;
            }
            finally {
                insert.close();
            }
        }
        catch (SeException e2) {
            e2.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private boolean spatialInsertByVersion(SeConnection connection, String layerName, Map<String, Object> columns) {
        block23: {
            try {
                SeVersion version = new SeVersion(connection, ARCSDE_DEFAULT_VERSION);
                SeState oldState = null;
                SeState newState = null;
                SeInsert insert = new SeInsert(connection);
                try {
                    oldState = new SeState(connection, version.getStateId());
                    if (oldState.isOpen()) {
                        try {
                            oldState.close();
                        }
                        catch (SeException e) {
                            e.printStackTrace();
                        }
                    }
                    newState = new SeState(connection);
                    newState.create(oldState.getId());
                    try {
                        connection.startTransaction();
                        insert.setState(newState.getId(), new SeObjectId(-1L), 0);
                        insert.intoTable(layerName, this.getColumnNames(columns));
                        insert.setWriteMode(true);
                        SeRow row = insert.getRowToSet();
                        this.setRowColumnsValue(row, columns);
                        insert.execute();
                        version.changeState(newState.getId());
                        connection.commitTransaction();
                        boolean bl = true;
                        return bl;
                    }
                    catch (SeException e) {
                        try {
                            this.logger.error("SDE\u7f16\u8f91\u6570\u636e\u5f02\u5e38\u3010{}\u3011", (Object)e.getSeError().getErrDesc());
                            connection.rollbackTransaction();
                        }
                        catch (SeException e2) {
                            e2.printStackTrace();
                            break block23;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        insert.close();
                        if (newState.isOpen()) {
                            try {
                                newState.close();
                            }
                            catch (SeException e3) {
                                e3.printStackTrace();
                            }
                        }
                    }
                }
                finally {
                    insert.close();
                    if (newState.isOpen()) {
                        try {
                            newState.close();
                        }
                        catch (SeException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (SeException e) {
                this.logger.error("SDE\u63d2\u5165\u6570\u636e\u51fa\u73b0\u5f02\u5e38\u3010{}\u3011", (Object)e.getSeError().getErrDesc());
            }
        }
        return false;
    }

    private List<Map<String, Object>> spatialQuery(SeConnection connection, SeShape shape, String layerName, String[] columns) {
        SeShapeFilter filter = new SeShapeFilter(layerName, "SHAPE", shape, 7);
        SeFilter[] filters = new SeFilter[]{filter};
        SeQuery query = null;
        SeSqlConstruct sqlConstruct = new SeSqlConstruct(layerName);
        try {
            if (columns == null | columns.length < 1) {
                columns = this.getLayerColumns(connection, layerName);
            }
            query = new SeQuery(connection, columns, sqlConstruct);
            query.prepareQuery();
            query.setSpatialConstraints((short)2, true, filters);
            query.execute();
            SeRow row = query.fetch();
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            while (row != null) {
                list.add(this.seRow2Map(row));
                row = query.fetch();
            }
            query.close();
            return list;
        }
        catch (SeException e) {
            e.printStackTrace();
            return null;
        }
    }

    private SeLayer getLayer(SeConnection connection, String layerName) throws SeException {
        if (connection == null || StringUtils.isBlank((String)layerName)) {
            return null;
        }
        SeLayer layer = new SeLayer(connection, layerName, "SHAPE");
        return layer;
    }

    private List<SeLayer> getLayers(String dbSource) throws SeException {
        SeConnection connection = this.getConnection(dbSource);
        return connection.getLayers();
    }

    private String[] getColumnNames(Map<String, ?> columns) {
        if (columns == null) {
            return new String[0];
        }
        ArrayList<String> names = new ArrayList<String>();
        for (String key : columns.keySet()) {
            if (key == null) continue;
            names.add(key);
        }
        return names.toArray(new String[names.size()]);
    }

    private String[] getLayerColumns(SeConnection connection, String layerName) {
        String[] cols = null;
        try {
            SeTable table = new SeTable(connection, layerName);
            SeColumnDefinition[] colDefs = table.describe();
            cols = new String[colDefs.length];
            for (int i = 0; i < colDefs.length; ++i) {
                cols[i] = colDefs[i].getName();
            }
        }
        catch (SeException e) {
            e.printStackTrace();
        }
        return cols;
    }

    private void setRowColumnsValue(SeRow row, Map<String, Object> columns) {
        try {
            for (int i = 0; i < row.getNumColumns(); ++i) {
                SeColumnDefinition colDef = row.getColumnDef(i);
                try {
                    if (columns.get(colDef.getName()) == null) continue;
                    int type = colDef.getType();
                    switch (type) {
                        case 5: {
                            row.setString(i, (String)columns.get(colDef.getName()));
                            break;
                        }
                        case 14: {
                            row.setNString(i, (String)columns.get(colDef.getName()));
                            break;
                        }
                        case 8: {
                            row.setShape(i, (SeShape)columns.get(colDef.getName()));
                            break;
                        }
                        case 2: {
                            row.setInteger(i, Integer.valueOf((String)columns.get(colDef.getName())));
                            break;
                        }
                        case 11: {
                            row.setLong(i, Long.valueOf((String)columns.get(colDef.getName())));
                            break;
                        }
                        case 1: {
                            row.setShort(i, Short.valueOf((String)columns.get(colDef.getName())));
                            break;
                        }
                        case 3: {
                            row.setFloat(i, Float.valueOf((String)columns.get(colDef.getName())));
                            break;
                        }
                        case 4: {
                            row.setDouble(i, Double.valueOf((String)columns.get(colDef.getName())));
                            break;
                        }
                        case 7: {
                            Calendar calendar = Calendar.getInstance();
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                            Date date = null;
                            try {
                                date = sdf.parse((String)columns.get(colDef.getName()));
                            }
                            catch (ParseException e) {
                                date = new Date();
                            }
                            calendar.setTime(date);
                            row.setTime(i, calendar);
                            break;
                        }
                        case 12: {
                            row.setUuid(i, (String)columns.get(colDef.getName()));
                            break;
                        }
                        case 13: {
                            row.setClob(i, new ByteArrayInputStream(((String)columns.get(colDef.getName())).getBytes()));
                            break;
                        }
                        case 15: {
                            row.setClob(i, new ByteArrayInputStream(((String)columns.get(colDef.getName())).getBytes()));
                            break;
                        }
                        case 10: {
                            SeXmlDoc xml = new SeXmlDoc();
                            xml.setText((String)columns.get(colDef.getName()));
                            row.setXml(i, xml);
                        }
                    }
                    continue;
                }
                catch (SeException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (SeException e) {
            e.printStackTrace();
        }
    }

    private Map seRow2Map(SeRow row) {
        if (row == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            int colCount = row.getNumColumns();
            SeColumnDefinition colDef = null;
            for (int i = 0; i < colCount; ++i) {
                colDef = row.getColumnDef(i);
                try {
                    int type = colDef.getType();
                    switch (type) {
                        case 5: {
                            map.put(colDef.getName(), row.getString(i));
                            break;
                        }
                        case 14: {
                            map.put(colDef.getName(), row.getNString(i));
                            break;
                        }
                        case 2: {
                            map.put(colDef.getName(), row.getInteger(i));
                            break;
                        }
                        case 8: {
                            try {
                                map.put(colDef.getName(), row.getShape(i));
                            }
                            catch (SeException e) {}
                            break;
                        }
                        case 7: {
                            map.put(colDef.getName(), row.getTime(i));
                            break;
                        }
                        case 1: {
                            map.put(colDef.getName(), row.getShort(i));
                            break;
                        }
                        case 11: {
                            map.put(colDef.getName(), row.getLong(i));
                            break;
                        }
                        case 3: {
                            map.put(colDef.getName(), row.getFloat(i));
                            break;
                        }
                        case 4: {
                            map.put(colDef.getName(), row.getDouble(i));
                            break;
                        }
                        case 12: {
                            map.put(colDef.getName(), row.getUuid(i));
                            break;
                        }
                        case 13: {
                            map.put(colDef.getName(), row.getClob(i));
                            break;
                        }
                        case 15: {
                            map.put(colDef.getName(), row.getNClob(i));
                            break;
                        }
                        case 10: {
                            map.put(colDef.getName(), row.getXml(i) != null ? row.getXml(i).getText() : "");
                        }
                    }
                    continue;
                }
                catch (SeException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (SeException e) {
            e.printStackTrace();
        }
        return map;
    }

    private boolean isLayerVersioned(SeConnection connection, SeLayer layer) {
        try {
            Vector registers = connection.getRegisteredTables();
            for (Object item : registers) {
                SeRegistration registration = (SeRegistration)item;
                if (!registration.hasLayer() || !registration.isMultiVersion() || !registration.getTableName().equals(layer.getTableName())) continue;
                return true;
            }
        }
        catch (SeException e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean contains(String[] src, String des) {
        return ArrayUtils.contains((String[])src, (String)des, (boolean)false);
    }
}

