/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.dao.impl;

import com.gtis.emapserver.core.dao.impl.GenericIbatisDao;
import com.gtis.emapserver.dao.DictDao;
import com.gtis.emapserver.entity.dict.Dict;
import com.gtis.emapserver.entity.dict.Item;
import java.util.List;
import org.springframework.stereotype.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository
public class DictDaoImpl
extends GenericIbatisDao<Dict, String>
implements DictDao {
    private static final String DICT_NS = "dict";

    public DictDaoImpl() {
        this.setSqlmapNamespace(DICT_NS);
    }

    public Dict getDict(String name) {
        return (Dict)this.getSqlMapClientTemplate().queryForObject(this.getSqlmapNamespace().concat(".getDict"), (Object)name);
    }

    public List<Item> getDictItems(String dictId) {
        return this.getSqlMapClientTemplate().queryForList(this.getSqlmapNamespace().concat(".getDictItems"), (Object)dictId);
    }

    public Item getDictItem(String itemId) {
        return (Item)this.getSqlMapClientTemplate().queryForObject(this.getSqlmapNamespace().concat(".getDictItem"), (Object)itemId);
    }

    public String saveDictItem(Item dictItem) {
        this.getSqlMapClientTemplate().insert(this.getSqlmapNamespace().concat(".insertItem"), (Object)dictItem);
        return dictItem.getId();
    }

    public void removeDictItem(String itemId) {
        this.getSqlMapClientTemplate().delete(this.getSqlmapNamespace().concat(".deleteItem"), (Object)itemId);
    }

    public int updateDictItem(Item item) {
        return this.getSqlMapClientTemplate().update(this.getSqlmapNamespace().concat(".updateDictItem"), (Object)item);
    }
}

