/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.core.ogc.impl;

import com.gtis.emapserver.core.ogc.GeometryOperation;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.stereotype.Service;

@Service
public class GeometryOperationImpl
implements GeometryOperation {
    private static final String EPSG = "EPSG:";
    private WKTReader wktReader = new WKTReader();

    public Geometry readGeo(String coords) throws ParseException {
        return this.wktReader.read(coords);
    }

    public Point readPoint(String coords) throws ParseException {
        return (Point)this.wktReader.read(coords);
    }

    public LineString readLineString(String coords) throws ParseException {
        return (LineString)this.wktReader.read(coords);
    }

    public Polygon readPolygon(String coords) throws ParseException {
        return (Polygon)this.wktReader.read(coords);
    }

    public MultiPolygon readMultiPolygon(String coords) throws ParseException {
        return (MultiPolygon)this.wktReader.read(coords);
    }

    public GeometryCollection readGeoCollection(String coords) throws ParseException {
        return (GeometryCollection)this.wktReader.read(coords);
    }

    public String getWKTStringFromSrid(int srid) throws FactoryException {
        CoordinateReferenceSystem crs = CRS.decode((String)(EPSG + srid));
        return crs.toWKT();
    }
}

