/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.core.arcsde.impl;

import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeException;
import com.gtis.emapserver.core.arcsde.ArcSDEPoolableConnectionFactory;
import com.gtis.emapserver.core.arcsde.SDEDataSource;
import java.sql.SQLException;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ArcSDEDataSource
extends BasicDataSource
implements SDEDataSource {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String server;
    private int port;
    private ArcSDEPoolableConnectionFactory factory;
    private volatile GenericObjectPool pool;

    private void createSdeDataSource() {
        this.createSdePoolFactory();
        this.createSeConnectionPool();
        try {
            this.pool.addObject();
        }
        catch (SeException ex) {
            this.logger.error("ArcSDE\u8fde\u63a5\u5f02\u5e38\u3010{}\u3011", (Object)ex.getLocalizedMessage());
        }
        catch (Exception e) {
            this.logger.error("\u521b\u5efaArcSDE\u6570\u636e\u6e90\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
        }
    }

    private void createSdePoolFactory() {
        this.factory = new ArcSDEPoolableConnectionFactory(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SeConnection getSeConnection() throws Exception {
        SeConnection seConnection;
        SeConnection seConnection2 = null;
        try {
            if (this.pool == null || this.factory == null) {
                this.createSdeDataSource();
            }
            seConnection = seConnection2 = (SeConnection)this.pool.borrowObject();
            if (seConnection2 == null) return seConnection;
        }
        catch (Exception e) {
            try {
                Assert.notNull(seConnection2, (String)"\u672a\u6b63\u5e38\u83b7\u53d6ArcSDE\u8fde\u63a5\uff01".concat(this.toString()));
                if (seConnection2 != null) {
                    this.pool.invalidateObject((Object)seConnection2);
                }
                this.logger.error("\u83b7\u53d6ArcSDE\u6570\u636e\u8fde\u63a5\u51fa\u73b0\u5f02\u5e38", e.getCause());
                if (seConnection2 == null) return null;
            }
            catch (Throwable throwable) {
                if (seConnection2 == null) throw throwable;
                this.pool.returnObject(seConnection2);
                throw throwable;
            }
            this.pool.returnObject((Object)seConnection2);
            return null;
        }
        this.pool.returnObject((Object)seConnection2);
        return seConnection;
    }

    private void createSeConnectionPool() {
        GenericObjectPool gop = null;
        gop = new GenericObjectPool((PoolableObjectFactory)this.factory);
        gop.setMaxActive(this.maxActive);
        gop.setMaxIdle(this.maxIdle);
        gop.setMinIdle(this.minIdle);
        gop.setMaxWait(this.maxWait);
        gop.setTestOnBorrow(this.testOnBorrow);
        gop.setTestOnReturn(this.testOnReturn);
        gop.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis);
        gop.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
        gop.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis);
        gop.setTestWhileIdle(this.testWhileIdle);
        this.pool = gop;
    }

    public synchronized void close() throws SQLException {
        try {
            this.pool.clear();
            this.pool.close();
        }
        catch (Exception e) {
            this.logger.error("\u5173\u95ed\u8fde\u63a5\u6c60\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
        }
        super.close();
    }

    public String toString() {
        return "ArcSDE " + this.getServer().concat(":").concat(String.valueOf(this.getPort())).concat("/" + this.getUsername());
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

