/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.emapserver.service.impl;

import com.gtis.emapserver.core.event.DictNoteFoundException;
import com.gtis.emapserver.dao.DictDao;
import com.gtis.emapserver.entity.dict.Dict;
import com.gtis.emapserver.entity.dict.Item;
import com.gtis.emapserver.service.DictService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class DictServiceImpl
implements DictService {
    @Autowired
    private DictDao dictDao;

    public List<Dict> getDicts() {
        return this.dictDao.getAll();
    }

    public Dict getDict(String name) {
        return this.dictDao.getDict(name);
    }

    public Dict getDictById(String id) {
        return (Dict)this.dictDao.find((Serializable)((Object)id));
    }

    public List<Item> getDictItems(String dictId) {
        return this.dictDao.getDictItems(dictId);
    }

    public List<Item> getDictItemsByName(String dictName) {
        Dict dict = this.getDict(dictName);
        if (dict == null) {
            throw new DictNoteFoundException(dictName);
        }
        return this.getDictItems(dict.getId());
    }

    public Item getDictItem(String itemId) {
        return this.dictDao.getDictItem(itemId);
    }

    public String saveDict(Dict dict) {
        this.dictDao.insert((Object)dict);
        return dict.getId();
    }

    public String updateDict(Dict dict) {
        this.dictDao.update((Object)dict);
        return dict.getId();
    }

    public String updateDictItem(Item item) {
        this.dictDao.updateDictItem(item);
        return item.getId();
    }

    public String saveDictItem(Item dictItem) {
        return this.dictDao.saveDictItem(dictItem);
    }

    public void removeDict(String id) {
        this.dictDao.delete((Serializable)((Object)id));
    }

    public void removeDictItem(String itemId) {
        this.dictDao.removeDictItem(itemId);
    }
}

